#!/bin/sh

# +----------------------------------------------------------+
# | Postinstall script for ESX3.5
# | Authors:
# | Gabrie van Zanten  http://www.GabesVirtualWorld.com 
# | Arnim van Lieshout  http://www.van-lieshout.com/
# +----------------------------------------------------------+

#+--------------------------------------------------------------------------+
#| At start of this script, show which values have been pasted
#| from  %PRE section, via call-esx-postinstall-3.5.sh            
#| This is only usefull for debugging 
#+--------------------------------------------------------------------------+
ESXHOSTIP=$1
ESXVMOTIONIP=$2
ESXCL=$3
echo Found ESX Host IP = $1
echo Found VMotion IP  = $2
echo Found Cluster  = $3

# +-------------------------------------------------------------------------------------+
#| Creating /root/esx-kernelconfig.sh file. This contains all commands that 
# | can only be executed when the vmkernel is loaded into memory
# +-------------------------------------------------------------------------------------+
cat > /root/esx-kernelconfig.sh <<EOF1
#!/bin/sh

# +---------------------------------------------------------------------------+
# | Creating Service Console vSwitch
# +---------------------------------------------------------------------------+

# Tijdens auto-install wordt al een vSwitch0 aangemaakt, deze wordt eerst verwijdert
# During normal install ESX creates a vSwitch0 by default. This is now deleted
esxcfg-vswif -d vswif0
esxcfg-vswitch --del-pg='Service Console' vSwitch0
esxcfg-vswitch -d vSwitch0

# Create a new Service Console switch
esxcfg-vswitch -a vsw-cos

# Connecting physical network adapters to the Service Console switch
esxcfg-vswitch -L vmnic0 vsw-cos
esxcfg-vswitch -L vmnic6 vsw-cos

# Connect Portgroups to vSwitch vsw-cos
esxcfg-vswitch --add-pg='Service Console' vsw-cos

# Create vswif interface
esxcfg-vswif -a vswif0 -p 'Service Console' -i $ESXHOSTIP -n 255.255.255.0

# +---------------------------------------------------------------------+
# | Create  VMOTION kernelswitch                                   |
# +---------------------------------------------------------------------+

esxcfg-vswitch -a vsw-vmotion 

# Connect physical network adapters to vsw-vmotion
esxcfg-vswitch -L vmnic2 vsw-vmotion 
esxcfg-vswitch -L vmnic8 vsw-vmotion

# Connect portgroups to vsw-vmotion 
esxcfg-vswitch --add-pg=vmotion vsw-vmotion

# Now connect the VMkernel NIC incl IP adres for vmotion
# This does not enable VMotion yet. 
esxcfg-vmknic -a "vmotion" -i $ESXVMOTIONIP -n 255.255.255.0

# Set vmkernel default gateway
esxcfg-route 172.29.28.254

# +------------------------------------------------------------------------+
# | Creating a  Quarantine kernelswitch  vsw-quarantine
# | This vSwitch has no network adapters and is used to put VMs in quarantine when
#|  IP or VLAN is still unknown
# +------------------------------------------------------------------------+

esxcfg-vswitch -a vsw-quarantine
esxcfg-vswitch --add-pg=quarantine vsw-quarantine

# +-------------------------------------------------------------------+
# | Create all Virtual Machine VLANs on vsw-vms01
# +-------------------------------------------------------------------+
esxcfg-vswitch -a vsw-vms01 

# Connect 4 network adapters to vsw-vms01
esxcfg-vswitch -L vmnic1 vsw-vms01 
esxcfg-vswitch -L vmnic3 vsw-vms01
esxcfg-vswitch -L vmnic7 vsw-vms01
esxcfg-vswitch -L vmnic9 vsw-vms01




# Now, depending on the cluster the ESX host will be part of, 
# we download vsw-vms01-<esxcl>.sh script and connect the portgroups of that cluster
# 192.168.0.1 is the IP of the UDA. Change this to match your UDA IP address.

/usr/sbin/esxcfg-firewall --allowOutgoing
lwp-download http://192.168.0.1/scripts/vsw-vms01-${ESXCL}.sh  /root/vsw-vms01-${ESXCL}.sh
chmod a+x /root/vsw-vms01-${ESXCL}.sh
/usr/sbin/esxcfg-firewall --blockOutgoing

# Execute vsw-vms01-${ESXCL}.sh script
/root/vsw-vms01-${ESXCL}.sh > /root/vsw-vms01-${ESXCL}.log 2>&1

# By default network adapters added to a vSwitch will go into standby mode
# This step ensures they are all active
sed -i -e 's/\/net\/vswitch\/child\[0000\]\/teamPolicy\/maxActive = "1"/\/net\/vswitch\/child\[0000\]\/teamPolicy\/maxActive = "2"/g' /etc/vmware/esx.conf
sed -i -e 's/\/net\/vswitch\/child\[0001\]\/teamPolicy\/maxActive = "1"/\/net\/vswitch\/child\[0001\]\/teamPolicy\/maxActive = "2"/g' /etc/vmware/esx.conf
sed -i -e 's/\/net\/vswitch\/child\[0003\]\/teamPolicy\/maxActive = "1"/\/net\/vswitch\/child\[0003\]\/teamPolicy\/maxActive = "4"/g' /etc/vmware/esx.conf

# +------------------------------------------------------------------+
# | The virtual network config is now complete
# +------------------------------------------------------------------+

# +------------------------------------------------------------------+
# | Now configure additional settings
# +------------------------------------------------------------------+


# Configure  Active Directory authentication
# Replace mycompany.local by the domain name of your internal network
# and dc01 by the name of the domain controller
esxcfg-auth --enablead --addomain=mycompany.local --addc=dc01.mycompany.local

# A number of users that will be allowed SSH access to the ESX host.
# They will also be member of the group wheel

useradd -G wheel user01
useradd -G wheel user02
useradd -G wheel user03

# Adding IP of secundairy DNS server / Name server
echo nameserver 192.168.0.2  >> /etc/resolv.conf

# +--------------------------------------------------------------------+
# | Configuring time sync
# +--------------------------------------------------------------------+

# Backup existing ntpd.conf and step-tickers 
mv /etc/ntp.conf /etc/ntp.conf.bak
mv /etc/ntp/step-tickers /etc/ntp/step-tickers.bak

# Add ntp servers to step-tickers
echo "ntp1.mycompany.local" > /etc/ntp/step-tickers
echo "ntp2.mycompany.local" >> /etc/ntp/step-tickers

# ntp.conf 
echo "restrict 127.0.0.1" > /etc/ntp.conf
echo "restrict default kod nomodify notrap noquery nopeer" >> /etc/ntp.conf
echo "server ntp1.mycompany.local" >> /etc/ntp.conf
echo "server ntp2.mycompany.local" >> /etc/ntp.conf
echo "driftfile /var/lib/ntp/drift" >> /etc/ntp.conf
echo "logfile /var/log/ntp" >> /etc/ntp.conf

# Configure firewall for ntp
/usr/sbin/esxcfg-firewall -e ntpClient

# Configure automatisch start for ntp
chkconfig --level 345 ntpd on

# Restart ntpd to active the new config
service ntpd restart

# Sync hardware clock
hwclock --systohc

# Unload VMFS2 drivers from kernel for performance improvement
mv /etc/init.d/vmware /etc/init.d/vmware.old
sed -e "s/echo \"vmfs2 vmfs2\"/\#echo \"vmfs2 vmfs2\"/g" /etc/init.d/vmware.old > /etc/init.d/vmware
chmod 744 /etc/init.d/vmware

# Configure Firewall for FastSCP (192.168.0.1 is UDA IP)
/usr/sbin/esxcfg-firewall --allowOutgoing
lwp-download http://192.168.0.1/scripts/FastSCP.xml /etc/vmware/firewall/FastSCP.xml
/usr/sbin/esxcfg-firewall --blockOutgoing
/usr/sbin/esxcfg-firewall -e FastSCP 

# Console Memory to 800MB
cp /boot/grub/grub.conf /boot/grub/grub.conf.bak 
sed -i -e 's/memSize = \"272\"/memSize = \"800\"/g' /etc/vmware/esx.conf
# Adjust grub.conf for boot
esxcfg-boot -g 
esxcfg-boot -b 

# Edit /etc/sudoers to allow members of the wheel group to sudo 
sed -i.bak -e "s/# %wheel\tALL=(ALL)\tNOPASSWD: ALL/%wheel\tALL=(ALL)\tNOPASSWD: ALL/1" /etc/sudoers

# enable VMotion
vmware-vim-cmd hostsvc/vmotion/vnic_set vmk0
vmware-vim-cmd internalsvc/refresh_network

# Ping vmkernel gateway, to activate vmknic  ( IP of the VMotion interface default gateway)
vmkping 192.168.10.254

# 
# End of script
EOF1

# All previous code was to create the esx-kernelconfig.sh file. Now make it executable
chmod +x /root/esx-kernelconfig.sh

#  Backup original rc.local file
cp /etc/rc.d/rc.local /etc/rc.d/rc.local.bak

# Edit rc.local to start esx-kernelconfig.sh after boot
# and also remove this line after running esx-kernelconfig.sh 
cat >> /etc/rc.d/rc.local <<EOF
/root/esx-kernelconfig.sh > /root/esx-kernelconfig.log 2>&1
mv -f /etc/rc.d/rc.local.bak /etc/rc.d/rc.local
reboot
EOF
