package com.mycompany.webapps.gi2spring.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import com.mycompany.webapps.gi2spring.model.ProductManager;

/**
 * Product List controller.
 * @author bwalsh
 */
 public class SpringappController implements Controller {

    /** Logger for this class and subclasses */
	static Logger logger = Logger.getLogger(SpringappController.class);
	
	/**
	 * service provides access to model.
	 */
	private ProductManager productManager;
	
	/**
	 * key for rendering / view layer.
	 */
	private String successView  = null ;
	
      
	/**
	 * implements controller.
	 */
	 //@SuppressWarnings("all")
	 public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

		// date for display
        String now = (new java.util.Date()).toString();
		// list of products
		List products = getProductManager().getProducts();

		// place data into rendering layer
        Map myModel = new HashMap();
        myModel.put("now", now);
		myModel.put("products", products);

		// return data with configured view and   
		String view = getSuccessView();
		logger.info("returning ["+view+"] view with " + now);

		return new ModelAndView(view, Constants.MODELNAME, myModel);
    }

	// ---------------------------------------------------------------------- accessors and mutators
    public void setProductManager(ProductManager pm) {
        productManager = pm;
    }

    public ProductManager getProductManager() {
        return productManager;
    }

	public String getSuccessView() {
		return successView;
	}
	

	public void setSuccessView(String successView) {
		this.successView = successView;
	}
	
}