package com.mycompany.webapps.gi2spring.controller;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;

public class ViewNameResolver {

	/**
	 * client passes if they want a GI compatible view
	 */
    static final String GI_VIEWNAME = "gi";
	static final  String GI_PARAMETERNAME = "isGI";

	
	
	/**
	 * given a viewName and a request, decorate view name.
	 * @param request
	 * @param viewName
	 * @return
	 */
	public static String resolveViewName(HttpServletRequest request, String viewName) {
		if ( isGIView(request)  ) {
			viewName = GI_VIEWNAME;
		}
		return viewName ;
	}

	/**
	 * true if request has non-null GI parameter
	 * @param request
	 * @return
	 */
	public static boolean isGIView(HttpServletRequest request) {
		return ! StringUtils.isEmpty( request.getParameter(GI_PARAMETERNAME) );
	}

	/**
	 * given a destination URL  and a request, decorate the url with our isGI in use 
	 * parameter.
	 * @param request
	 * @param url
	 * @return
	 */
	public static String resolveURL(HttpServletRequest request, String url) {
		if ( isGIView(request)  ) {
			url += "?"+ GI_PARAMETERNAME + "=" + request.getParameter(GI_PARAMETERNAME) ;
		}
		return url ;
	}


}
