<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" omit-xml-declaration="yes"/>
  <xsl:param name="jsxtabindex">0</xsl:param>
  <xsl:param name="jsxicon">JSX/images/tree/file.gif</xsl:param>
  <xsl:param name="jsxiconminus">JSX/images/tree/minus.gif</xsl:param>
  <xsl:param name="jsxiconplus">JSX/images/tree/plus.gif</xsl:param>
  <xsl:param name="jsxtransparentimage">JSX/images/spc.gif</xsl:param>
  <xsl:param name="jsxdragtype">JSX_GENERIC</xsl:param>
  <xsl:param name="jsxrootid">jsxnull</xsl:param>
  <xsl:param name="jsxselectedid">jsxnull</xsl:param>
  <xsl:param name="jsxselectedimage">JSX/images/tree/selected.gif</xsl:param>
  <xsl:param name="jsxbordercolor">#8d9ec1</xsl:param>
  <xsl:param name="jsxid">_jsx_JSX1_12</xsl:param>
  <xsl:param name="jsxuseroot">1</xsl:param>
  <xsl:param name="jsxlinkimage">JSX/addins/mapping/images/link.gif</xsl:param>
  <xsl:param name="jsxrepeatimage">JSX/addins/mapping/images/repeat.gif</xsl:param>

  <xsl:param name="jsximg">
    <lookup id="O" src="JSX/addins/mapping/images/inbound_map.gif"/>
    <lookup id="I" src="JSX/addins/mapping/images/outbound_map.gif"/>
    <lookup id="W" src="JSX/addins/mapping/images/wsdl.gif"/>
    <lookup id="T" src="JSX/addins/mapping/images/wsdl.gif"/>
    <lookup id="S" src="JSX/addins/mapping/images/service.gif"/>
    <lookup id="P" src="JSX/addins/mapping/images/operation.gif"/>
    <lookup id="C" src="JSX/addins/mapping/images/complex_1.gif"/>
    <lookup id="D" src="JSX/addins/mapping/images/cdata.gif"/>
    <lookup id="E" src="JSX/addins/mapping/images/edit.gif"/>
    <lookup id="F" src="JSX/addins/mapping/images/fault.gif"/>
    <lookup id="A" src="JSX/addins/mapping/images/attribute.gif"/>
  </xsl:param>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$jsxuseroot=1">
        <xsl:apply-templates select="//*[@jsxid=$jsxrootid]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="//*[@jsxid=$jsxrootid]/record"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*">
    <xsl:param name="myjsxid" select="@jsxid"/>
    <xsl:param name="mystyle" select="@jsxstyle"/>
    <xsl:param name="myimg" select="@type"/>
    <xsl:param name="myimgs" select="$jsximg"/>
    <xsl:variable name="latticestyle"><xsl:choose><xsl:when test="@groupref='1'">color:#c8c8c8;font-style:italic;</xsl:when></xsl:choose></xsl:variable>
    <xsl:variable name="selectionstyle"><xsl:choose><xsl:when test="@jsxselected='1'">background-image:url(<xsl:value-of select="$jsxselectedimage"/>);border-right:solid 1px <xsl:value-of select="$jsxbordercolor"/>;</xsl:when></xsl:choose></xsl:variable>
    <xsl:variable name="myimgsrc"><xsl:value-of select="$myimgs/*[@id=$myimg]/@src"/></xsl:variable>

    <span jsxtype='item' class='jsx30tree_item' id="{$jsxid}_{$myjsxid}">
      <xsl:attribute name="jsxid"><xsl:value-of select="@jsxid"/></xsl:attribute>
      <span jsxtype='caption' class='jsx30tree_caption' >
        <xsl:choose>
          <xsl:when test="record and @jsxopen=1">
            <img jsxtype="plusminus" align="absbottom" src="{$jsxiconminus}" class="jsx30tree_pm"/>
          </xsl:when>
          <xsl:when test="record">
            <img jsxtype="plusminus" align="absbottom" src="{$jsxiconplus}" class="jsx30tree_pm"/>
          </xsl:when>
          <xsl:otherwise>
            <img jsxtype="space" align="absbottom" src="{$jsxtransparentimage}" class="jsx30tree_pm"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="@type">
            <img jsxtype="icon" unselectable="on" align="absbottom" class="jsx30tree_pm">
              <xsl:attribute name="src"><xsl:choose><xsl:when test="$myimgsrc='JSX/addins/mapping/images/complex_1.gif' and not(record)">JSX/addins/mapping/images/complex_0.gif</xsl:when><xsl:otherwise><xsl:value-of select="$myimgsrc"/></xsl:otherwise></xsl:choose></xsl:attribute>
            </img>
          </xsl:when>
          <xsl:otherwise>
            <img jsxtype="icon" unselectable="on" class="jsx30tree_pm" src="{$jsxicon}"/>
          </xsl:otherwise>
        </xsl:choose>
        <span jsxtype="text" unselectable="on" class="jsx30tree_text" tabindex="{$jsxtabindex}" JSXDragType="{$jsxdragtype}">
          <xsl:choose><xsl:when test="@jsxtip"><xsl:attribute name="title"><xsl:value-of select="@jsxtip"/></xsl:attribute></xsl:when></xsl:choose>
          <xsl:attribute name="JSXSpyglass"><xsl:value-of select="@jsxid"/></xsl:attribute>
          <xsl:attribute name="JSXDragId"><xsl:value-of select="@jsxid"/></xsl:attribute>
          <xsl:attribute name="style"><xsl:value-of select="$latticestyle"/><xsl:value-of select="$selectionstyle"/><xsl:value-of select="@jsxstyle"/></xsl:attribute>
          <xsl:choose><xsl:when test="@repeat"><span style="color:#01B40A;font-weight:bold;{$latticestyle}">[&amp;] </span></xsl:when></xsl:choose>
          <xsl:choose><xsl:when test="mappings/record"><span style="color:#3030cf;font-weight:bold;{$latticestyle}">[^] </span></xsl:when></xsl:choose>
          <xsl:choose><xsl:when test="restrictions/record[@name!='minoccur' and @name!='maxoccur']"><span style="color:orange;font-weight:bold;{$latticestyle}">[R] </span></xsl:when></xsl:choose>
          <xsl:value-of select="@jsxtext"/>
          <xsl:choose>
            <xsl:when test="@datatype != ''">
              <span style="color:#00aa00;{$latticestyle}"> [<xsl:value-of select="@datatype"/>]</span>
            </xsl:when>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="not(restrictions/record[@name='maxoccur']/@value = '' and restrictions/record[@name='minoccur']/@value = '')">
              <span style="color:blue;{$latticestyle}">
                (
                <xsl:choose>
                  <xsl:when test="restrictions/record[@name='minoccur']">
                    <xsl:value-of select="restrictions/record[@name='minoccur']/@value"/>
                  </xsl:when>
                  <xsl:otherwise>
                    1
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="restrictions/record[@name='maxoccur']">
                  - <xsl:value-of select="restrictions/record[@name='maxoccur']/@value"/>
                </xsl:if>
                )
              </span>
            </xsl:when>
          </xsl:choose>
        </span>
      </span>
      <span jsxtype="content" unselectable="on" class='jsx30tree_content'>
        <xsl:choose>
          <xsl:when test="record">
            <!-- recurse here -->
            <xsl:choose>
              <xsl:when test="@jsxopen='1'">
                <xsl:attribute name="style">display:block;</xsl:attribute>
              </xsl:when>
            </xsl:choose>
            <xsl:apply-templates select="record"/>
          </xsl:when>
        </xsl:choose>
      </span>
    </span>
  </xsl:template>

</xsl:stylesheet>
