package com.mycompany.webapps.gi2spring.controller;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;

import com.mycompany.webapps.gi2spring.model.PriceIncrease;
import com.mycompany.webapps.gi2spring.model.ProductManager;

public class PriceIncreaseFormController extends SimpleFormController  { // 
	/** Logger for this class */
	static Logger logger = Logger.getLogger(PriceIncreaseFormController.class);

	/**
	 * product service .
	 */
	private ProductManager prodMan;

	

	 /**
	  * handle form.
	  */
	//@Override
	protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException bindException) throws Exception {
		int increase = ((PriceIncrease) command).getPercentage();
		logger.info("Increasing prices by " + increase + "%.");
		prodMan.increasePrice(increase);
		String view = getSuccessView();
		logger.info("redirecting to view " + view );
		return new ModelAndView(new RedirectView(view));
	}



	protected Object formBackingObject(HttpServletRequest request)
			throws ServletException {
		PriceIncrease priceIncrease = new PriceIncrease();
		priceIncrease.setPercentage(20);
		return priceIncrease;
	}

	public void setProductManager(ProductManager pm) {
		prodMan = pm;
	}

	public ProductManager getProductManager() {
		return prodMan;
	}
}