<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" omit-xml-declaration="yes"/>

  <xsl:param name="jsxtabindex">0</xsl:param>
  <xsl:param name="jsxselectedimage">JSX/images/menu/selected.gif</xsl:param>
  <xsl:param name="jsxtransparentimage">JSX/images/spc.gif</xsl:param>
  <xsl:param name="jsxsubmenuimage">JSX/images/menu/submenuarrow.gif</xsl:param>
  <xsl:param name="jsxdragtype">JSX_GENERIC</xsl:param>
  <xsl:param name="jsxrootid">jsxroot</xsl:param>
  <xsl:param name="jsxid">jsxroot</xsl:param>
  <xsl:param name="jsxindex">0</xsl:param>
  <xsl:param name="jsxsortpath">jsx</xsl:param>
  <xsl:param name="jsxsortdirection">ascending</xsl:param>
  <xsl:param name="jsxsorttype">text</xsl:param>
  <xsl:param name="jsxapppath"></xsl:param>
  <xsl:param name="jsxabspath"></xsl:param>
  <xsl:param name="jsxdisableescape">no</xsl:param>

  <xsl:template match="/">
    <xsl:apply-templates select="//*[@jsxid=$jsxrootid]"/>
  </xsl:template>

  <xsl:template match="*">
    <xsl:param name="mystyle" select="@jsxstyle"/>

     <xsl:for-each select="record">
      <xsl:sort select="@*[name()=$jsxsortpath]" data-type="{$jsxsorttype}" order="{$jsxsortdirection}"/>
      <xsl:choose><xsl:when test="@jsxdivider[.='1']">
        <div class="jsx30menu_item_divider" jsxtype="Disabled"></div>
      </xsl:when></xsl:choose>
      <div id="{$jsxid}{@jsxid}" tabindex="{$jsxtabindex}" onmouseover="this.focus();" onmouseout="this.blur();" onfocus="jsx3.Menu.doFocus(this,'{$jsxid}',{$jsxindex});" onblur="jsx3.Menu.doBlur(this,'{$jsxid}',{$jsxindex});">
        <xsl:attribute name="jsxid"><xsl:value-of select="@jsxid"/></xsl:attribute>
        <xsl:choose>
          <xsl:when test="@jsxdisabled[.='1']"><xsl:attribute name="class">jsx30menu_item_disabled</xsl:attribute></xsl:when>
          <xsl:otherwise><xsl:attribute name="class">jsx30menu_item</xsl:attribute></xsl:otherwise>
        </xsl:choose>
        <xsl:choose><xsl:when test="@jsxtip"><xsl:attribute name="title"><xsl:value-of select="@jsxtip"/></xsl:attribute></xsl:when></xsl:choose>
        <xsl:choose>
          <xsl:when test="@jsxdisabled='1'"><xsl:attribute name="jsxtype">Disabled</xsl:attribute></xsl:when>
          <xsl:when test="record"><xsl:attribute name="jsxtype">Book</xsl:attribute></xsl:when>
          <xsl:otherwise><xsl:attribute name="jsxtype">Leaf</xsl:attribute></xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="@jsximg">
            <img style="position:absolute;left:2px;top:2px;width:16px;height:16px;">
              <xsl:attribute name="src"><xsl:value-of select="@jsximg"/></xsl:attribute>
            </img>
          </xsl:when>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="@jsxselected = 1"><img class="jsx30menu_selected" src="{$jsxselectedimage}"/></xsl:when>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="record">
            <span class="jsx30menu_text" style="background-image:url({$jsxsubmenuimage});background-position-x:right;background-position-y:2;background-repeat:no-repeat;{$mystyle}" JSXDragType="{$jsxdragtype}">
              <xsl:attribute name="JSXSpyglass"><xsl:value-of select="@jsxid"/></xsl:attribute>
              <xsl:attribute name="JSXDragId"><xsl:value-of select="@jsxid"/></xsl:attribute>
              <xsl:apply-templates select="." mode="jsxtext"/>
            </span>
          </xsl:when>
          <xsl:otherwise>
            <span class="jsx30menu_kc" JSXDragType="{$jsxdragtype}" style="{$mystyle}">
              <xsl:attribute name="JSXDragId"><xsl:value-of select="@jsxid"/></xsl:attribute>
              <xsl:attribute name="JSXSpyglass"><xsl:value-of select="@jsxid"/></xsl:attribute>
              <table class="jsx30menu_kct">
                <tr>
                  <td class="name"><xsl:apply-templates select="." mode="jsxtext"/></td>
                <xsl:if test="@jsxkeycode">
                  <td class="keycode"><xsl:value-of select="@jsxkeycode"/></td>
                </xsl:if>
              </tr>
             </table>
            </span>
          </xsl:otherwise>
        </xsl:choose>
      </div>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="record" mode="jsxtext">
    <xsl:choose>
      <xsl:when test="$jsxdisableescape='yes'">
        <xsl:value-of select="@jsxtext" disable-output-escaping="yes"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="@jsxtext" disable-output-escaping="no"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
