<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" omit-xml-declaration="yes"/>
  <xsl:param name="jsxtabindex">0</xsl:param>
  <xsl:param name="jsxselectedimage">JSX/images/select/selected.gif</xsl:param>
  <xsl:param name="jsxtransparentimage">JSX/images/spc.gif</xsl:param>
  <xsl:param name="jsxdragtype">JSX_GENERIC</xsl:param>
  <xsl:param name="jsxselectedid">null</xsl:param>
  <xsl:param name="jsxsortpath">jsximg</xsl:param>
  <xsl:param name="jsxsortdirection">ascending</xsl:param>
  <xsl:param name="jsxsorttype">text</xsl:param>
  <xsl:param name="jsxid">_jsx_blah_21</xsl:param>
  <xsl:param name="jsxapppath"></xsl:param>
  <xsl:param name="jsxabspath"></xsl:param>
  <xsl:param name="jsxdisableescape">no</xsl:param>
  <xsl:param name="jsxshallowfrom"></xsl:param>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$jsxshallowfrom">
        <xsl:for-each select="//*[@jsxid=$jsxshallowfrom]/record">
          <xsl:sort select="@*[name()=$jsxsortpath]" data-type="{$jsxsorttype}" order="{$jsxsortdirection}"/>
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="//record">
          <xsl:sort select="@*[name()=$jsxsortpath]" data-type="{$jsxsorttype}" order="{$jsxsortdirection}"/>
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="record">
    <xsl:param name="myjsxid" select="@jsxid"/>

    <div id="{$jsxid}{$myjsxid}" style="position:relative;" selType="Option" tabindex="{$jsxtabindex}">
      <xsl:attribute name="title"><xsl:value-of select="@jsxtip"/></xsl:attribute>
      <xsl:attribute name="jsxid"><xsl:value-of select="@jsxid"/></xsl:attribute>
      <xsl:attribute name="class">jsx30select_option</xsl:attribute>
      <xsl:attribute name="onmouseover">this.focus();</xsl:attribute>
      <xsl:attribute name="onmouseout">this.blur();</xsl:attribute>
      <xsl:attribute name="onfocus">jsx3.Select.doFocus(this);</xsl:attribute>
      <xsl:attribute name="onblur">jsx3.Select.doBlur(this);</xsl:attribute>
      <xsl:choose>
        <xsl:when test="$jsxselectedid=@jsxid">
          <img src="{$jsxselectedimage}" style="width:7px;height:7px;" align="middle"/>
        </xsl:when>
        <xsl:otherwise>
          <img src="{$jsxtransparentimage}" style="width:7px;height:7px;" align="middle"/>
        </xsl:otherwise>
      </xsl:choose>
      <span style="position:absolute;left:14px;top:4px;white-space:nowrap;overflow:hidden;" JSXDragType="{$jsxdragtype}">
        <xsl:attribute name="JSXSpyglass">
          <xsl:value-of select="@jsxid"/>
        </xsl:attribute>
        <xsl:attribute name="JSXDragId">
          <xsl:value-of select="@jsxid"/>
        </xsl:attribute>
        <xsl:apply-templates select="." mode="jsxtext"/>
      </span>
    </div>
  </xsl:template>

  <xsl:template match="record" mode="jsxtext">
    <xsl:choose>
      <xsl:when test="$jsxdisableescape='yes'">
        <xsl:value-of select="@jsxtext" disable-output-escaping="yes"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="@jsxtext" disable-output-escaping="no"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
