<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" omit-xml-declaration="yes"/>
  <xsl:param name="jsxtabindex">0</xsl:param>
  <xsl:param name="jsxicon">JSX/images/tree/file.gif</xsl:param>
  <xsl:param name="jsxiconminus">JSX/images/tree/minus.gif</xsl:param>
  <xsl:param name="jsxiconplus">JSX/images/tree/plus.gif</xsl:param>
  <xsl:param name="jsxtransparentimage">JSX/images/spc.gif</xsl:param>
  <xsl:param name="jsxdragtype">JSX_GENERIC</xsl:param>
  <xsl:param name="jsxrootid">jsxnull</xsl:param>
  <xsl:param name="jsxselectedimage">JSX/images/tree/selected.gif</xsl:param>
  <xsl:param name="jsxbordercolor">#8d9ec1</xsl:param>
  <xsl:param name="jsxid">_jsx_JSX1_12</xsl:param>
  <xsl:param name="jsxuseroot">1</xsl:param>
  <xsl:param name="jsxapppath"></xsl:param>
  <xsl:param name="jsxabspath"></xsl:param>
  <xsl:param name="jsxsortpath"></xsl:param>
  <xsl:param name="jsxsortdirection">ascending</xsl:param>
  <xsl:param name="jsxsorttype">text</xsl:param>
  <xsl:param name="jsxdeepfrom">jsxnull</xsl:param>
  <xsl:param name="jsxfragment">0</xsl:param>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$jsxdeepfrom != 'jsxnull' and $jsxfragment != '1'">
        <xsl:apply-templates select="//*[@jsxid=$jsxdeepfrom]"/>
      </xsl:when>
      <xsl:when test="$jsxuseroot=1">
        <xsl:apply-templates select="//*[@jsxid=$jsxrootid]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="//*[@jsxid=$jsxrootid]/record">
          <xsl:sort select="@*[name()=$jsxsortpath]" data-type="{$jsxsorttype}" order="{$jsxsortdirection}"/>
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*">
    <xsl:param name="myjsxid" select="@jsxid"/>
    <xsl:param name="mystyle" select="@jsxstyle"/>
    <xsl:param name="myclass" select="@jsxclass"/>

    <span jsxtype='item' class='jsx30tree_item' id="{$jsxid}_{$myjsxid}">
      <xsl:attribute name="jsxid"><xsl:value-of select="@jsxid"/></xsl:attribute>
      <span jsxtype='caption' class='jsx30tree_caption' >
        <xsl:choose>
          <xsl:when test="record and @jsxopen=1">
            <img jsxtype="plusminus" align="absbottom" src="{$jsxiconminus}" class="jsx30tree_pm"/>
          </xsl:when>
          <xsl:when test="record">
            <img jsxtype="plusminus" align="absbottom" src="{$jsxiconplus}" class="jsx30tree_pm"/>
          </xsl:when>
          <xsl:otherwise>
            <img jsxtype="space" align="absbottom" src="{$jsxtransparentimage}" class="jsx30tree_pm"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="@jsximg=''">
            <span style="display:none;width:1px;height1px;"></span>
          </xsl:when>
          <xsl:when test="@jsximg">
            <img jsxtype="icon" unselectable="on" align="absbottom" class="jsx30tree_pm">
              <xsl:attribute name="src"><xsl:value-of select="@jsximg"/></xsl:attribute>
            </img>
          </xsl:when>
          <xsl:when test="$jsxicon=''">
            <span style="display:none;width:1px;height1px;"></span>
          </xsl:when>
          <xsl:otherwise>
            <img jsxtype="icon" unselectable="on" class="jsx30tree_pm" src="{$jsxicon}"/>
          </xsl:otherwise>
        </xsl:choose>
        <span jsxtype="text" unselectable="on" class="jsx30tree_text {$myclass}" tabindex="{$jsxtabindex}" style="background-image:url({$jsxselectedimage});border-right:solid 1px {$jsxbordercolor};{$mystyle}" JSXDragType="{$jsxdragtype}">
          <xsl:choose>
            <xsl:when test="not(@jsxselected) or @jsxselected!='1'"><xsl:attribute name="style">background-image:;border-right:;<xsl:value-of select="@jsxstyle"/></xsl:attribute></xsl:when>
          </xsl:choose>
          <xsl:choose><xsl:when test="@jsxtip"><xsl:attribute name="title"><xsl:value-of select="@jsxtip"/></xsl:attribute></xsl:when></xsl:choose>
          <xsl:attribute name="JSXSpyglass"><xsl:value-of select="@jsxid"/></xsl:attribute>
          <xsl:attribute name="JSXDragId"><xsl:value-of select="@jsxid"/></xsl:attribute>
          <xsl:value-of select="@jsxtext"/>
        </span>
      </span>
      <span jsxtype="content" unselectable="on" class='jsx30tree_content'>
        <xsl:choose>
          <xsl:when test="record">
            <!-- recurse here -->
            <xsl:choose>
              <xsl:when test="@jsxopen='1'">
                <xsl:attribute name="style">display:block;</xsl:attribute>
              </xsl:when>
            </xsl:choose>
            <xsl:for-each select="record">
              <xsl:sort select="@*[name()=$jsxsortpath]" data-type="{$jsxsorttype}" order="{$jsxsortdirection}"/>
              <xsl:apply-templates select="."/>
            </xsl:for-each>
          </xsl:when>
        </xsl:choose>
      </span>
    </span>
  </xsl:template>

</xsl:stylesheet>
