package com.mycompany.webapps.gi2spring.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

import com.mycompany.webapps.gi2spring.model.Product;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

public class TestXStream extends TestCase {

	//@SuppressWarnings("all")
	public void testXMLSerialization() {

		Product  product = new Product() ;
		
		product.setDescription( "test description <>") ;
		product.setPrice(new Double(2.0)) ;

		XStream xstream = new XStream(new DomDriver()); // does not require XPP3
														// library
 		  
		String xml = xstream.toXML(product); 
		

		Product  product2 = (Product) xstream.fromXML(xml);
		
		assertEquals( product,product2);
		
		 List l = new ArrayList() ;
		 
		 l.add(product);
		 l.add(product2);
		 
		
		 List l2  = (List) xstream.fromXML(xstream.toXML(l));
		 
		 assertEquals( l,l2);
		 		
		 Map m = new HashMap() ;
		 m.put("now" , (new Date()).toString() ) ;
		 m.put("products" ,l2 ) ;
		 
 
		 
		 System.err.println("FYI:\n"+ xstream.toXML(m) );
		 
		 
			
	}

}
