package com.mvcsoft.sample;

import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.util.Collection;
import java.util.Iterator;

public class Client
{
  
  private static FacadeHome getFacadeHome()
  {
    try
    {
      InitialContext initial = new InitialContext();
      return (FacadeHome)
        PortableRemoteObject.narrow(
          initial.lookup( "FacadeEJB" ),
          FacadeHome.class );
    }
    catch (Exception e)
    {
      throw new javax.ejb.EJBException( e );
    }
  }
  

  public static void main(String[] args)
    throws Exception
  {
    Facade facade = getFacadeHome().create();
    if (args[0].equalsIgnoreCase("test_data"))
      facade.makeTestData();
    else if (args[0].equalsIgnoreCase("run"))
    {
      Collection all = facade.getAllNamesAndCredit();
      for (Iterator iterator = all.iterator(); iterator.hasNext();)
      {
        ViewNameAndCredit viewNameAndCredit = (ViewNameAndCredit) iterator.next();
        System.out.println(viewNameAndCredit);
      }
    }

  }
}

