package com.mvcsoft.sample;

import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.EJBException;
import javax.naming.InitialContext;

public abstract class CorporationBean implements EntityBean
{
  // cmp accessors
  
  public abstract Integer getId();
  public abstract void setId( Integer id );
  
  public abstract String getName();
  public abstract void setName( String name );
  
  public abstract String getCreditLimit();
  public abstract void setCreditLimit( String creditLimit );
  

  // cmr accessors
  
  public abstract PartyLocal getParty();
  public abstract void setParty( PartyLocal party );

  // business methods

  public String getDisplayName()
  {
    return "CORP: " + getName();
  }

  public String getCreditLimitCode()
  {
    return getCreditLimit();
  }

  private PartyLocalHome getPartyLocalHome()
  {
    try
    {
      InitialContext initial = new InitialContext();
      return (PartyLocalHome)
        initial.lookup( "java:comp/env/ejb/PartyLocalEJB" );
    }
    catch (Exception e)
    {
      throw new javax.ejb.EJBException( e );
    }
  }

  public ViewCorporation getViewCorporation()
  {
    ViewCorporation view = new ViewCorporation();
    view.setId( getId() );
    view.setName( getName() );
    view.setCreditLimit( getCreditLimit() );
    return view;
  }

  public void setViewCorporation( ViewCorporation view )
  {
    if (view.isIdSet() )
    {
      setId( view.getId() );
    }
    if (view.isNameSet() )
    {
      setName( view.getName() );
    }
    if (view.isCreditLimitSet() )
    {
      setCreditLimit( view.getCreditLimit() );
    }
  }

  public Integer ejbCreate( ViewCorporation view )
    throws CreateException
  {
    getPartyLocalHome().create(new ViewParty(view.getId(), "C"));
    setViewCorporation( view );
    return null;
  }

  public void ejbPostCreate( ViewCorporation view )
    throws CreateException
  {
    try
    {
      PartyLocal party = getPartyLocalHome().findByPrimaryKey(view.getId());
      setParty( party );
    }
    catch (FinderException e)
    {
      throw new EJBException( "Party not created" );
    }
  }

  public void ejbActivate() {}
  public void ejbLoad() {}
  public void ejbPassivate() {}
  public void ejbRemove() {}
  public void ejbStore() {}
  public void setEntityContext(EntityContext ctx) {}
  public void unsetEntityContext() {}
}