package com.mvcsoft.sample;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;

public class FacadeBean implements SessionBean
{
  private SessionContext ctx;


  public void makeTestData()
    throws CreateException
  {
    PersonLocalHome personHome = getPersonLocalHome();
    personHome.create(new ViewPerson(new Integer(1), "Daniel", "OConnor"));
    personHome.create(new ViewPerson(new Integer(2), "Lynne", "Older"));
    personHome.create(new ViewPerson(new Integer(3), "Patricia", "Mahar"));

    CorporationLocalHome corpHome = getCorporationLocalHome();
    corpHome.create(new ViewCorporation(new Integer(4), "MVCSoft", "AAA"));
    corpHome.create(new ViewCorporation(new Integer(5), "ACME", "BA"));
    corpHome.create(new ViewCorporation(new Integer(6), "Enron", "F"));

  }

  public Collection getAllNamesAndCredit()
    throws FinderException
  {
    LinkedList returnResults = new LinkedList();

    PartyLocalHome home = getPartyLocalHome();
    Collection allParties = home.findAll();
    for (Iterator iterator = allParties.iterator(); iterator.hasNext();)
    {
      PartyLocal partyLocal = (PartyLocal) iterator.next();
      returnResults.add( new ViewNameAndCredit(partyLocal.getDisplayName(),
        partyLocal.getCreditLimitCode() ));
    }
    return returnResults;
  }

  private PartyLocalHome getPartyLocalHome()
  {
    try
    {
      InitialContext initial = new InitialContext();
      return (PartyLocalHome)
        initial.lookup( "java:comp/env/ejb/PartyLocalEJB" );
    }
    catch (Exception e)
    {
      throw new javax.ejb.EJBException( e );
    }
  }
  
  private CorporationLocalHome getCorporationLocalHome()
  {
    try
    {
      InitialContext initial = new InitialContext();
      return (CorporationLocalHome)
        initial.lookup( "java:comp/env/ejb/CorporationLocalEJB" );
    }
    catch (Exception e)
    {
      throw new javax.ejb.EJBException( e );
    }
  }
  
  private PersonLocalHome getPersonLocalHome()
  {
    try
    {
      InitialContext initial = new InitialContext();
      return (PersonLocalHome)
        initial.lookup( "java:comp/env/ejb/PersonLocalEJB" );
    }
    catch (Exception e)
    {
      throw new javax.ejb.EJBException( e );
    }
  }
  

  
  public void ejbCreate() {}
  

  public void ejbActivate() {}
  public void ejbRemove() {}
  public void ejbPassivate() {}
  public void setSessionContext(SessionContext ctx) {this.ctx = ctx;}
}
