package com.mvcsoft.sample;

import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.EJBException;
import javax.naming.InitialContext;

public abstract class PartyBean implements EntityBean
{
  // cmp accessors
  
  public abstract Integer getId();
  public abstract void setId( Integer id );
  
  public abstract String getTypeCode();
  public abstract void setTypeCode( String typeCode );
  

  // cmr accessors
  
  public abstract CorporationLocal getCorporation();
  public abstract void setCorporation( CorporationLocal corporation );
  
  public abstract PersonLocal getPerson();
  public abstract void setPerson( PersonLocal person );

  // business methods

  public String getDisplayName()
  {
    String code = getTypeCode();
    if (code.equals("I"))
      return getPerson().getDisplayName();
    else if (code.equals("C"))
      return getCorporation().getDisplayName();
    throw new EJBException( "Unknown type" );
  }

  public String getCreditLimitCode()
  {
    String code = getTypeCode();
    if (code.equals("I"))
      return getPerson().getCreditLimitCode();
    else if (code.equals("C"))
      return getCorporation().getCreditLimitCode();
    throw new EJBException( "Unknown type" );
  }

  public ViewParty getViewParty()
  {
    ViewParty view = new ViewParty();
    view.setId( getId() );
    view.setTypeCode( getTypeCode() );
    return view;
  }

  public void setViewParty( ViewParty view )
  {
    if (view.isIdSet() )
    {
      setId( view.getId() );
    }
    if (view.isTypeCodeSet() )
    {
      setTypeCode( view.getTypeCode() );
    }
  }

  public Integer ejbCreate( ViewParty view )
    throws CreateException
  {
    setViewParty( view );
    return null;
  }

  public void ejbPostCreate( ViewParty view )
    throws CreateException
  {
  }
  

  public void ejbActivate() {}
  public void ejbLoad() {}
  public void ejbPassivate() {}
  public void ejbRemove() {}
  public void ejbStore() {}
  public void setEntityContext(EntityContext ctx) {}
  public void unsetEntityContext() {}
}