package com.mvcsoft.sample;

import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.EJBException;
import javax.naming.InitialContext;

public abstract class PersonBean implements EntityBean
{
  // cmp accessors
  
  public abstract Integer getId();
  public abstract void setId( Integer id );
  
  public abstract String getFirstName();
  public abstract void setFirstName( String firstName );
  
  public abstract String getLastName();
  public abstract void setLastName( String lastName );
  

  // cmr accessors
  
  public abstract PartyLocal getParty();
  public abstract void setParty( PartyLocal party );

  // business methods

  public String getDisplayName()
  {
    return "IND: " + getLastName() + ", " + getFirstName();
  }

  public String getCreditLimitCode()
  {
    return "000";
  }

  private PartyLocalHome getPartyLocalHome()
  {
    try
    {
      InitialContext initial = new InitialContext();
      return (PartyLocalHome)
        initial.lookup( "java:comp/env/ejb/PartyLocalEJB" );
    }
    catch (Exception e)
    {
      throw new javax.ejb.EJBException( e );
    }
  }
  

  
  public ViewPerson getViewPerson()
  {
    ViewPerson view = new ViewPerson();
    view.setId( getId() );
    view.setFirstName( getFirstName() );
    view.setLastName( getLastName() );
    return view;
  }

  public void setViewPerson( ViewPerson view )
  {
    if (view.isIdSet() )
    {
      setId( view.getId() );
    }
    if (view.isFirstNameSet() )
    {
      setFirstName( view.getFirstName() );
    }
    if (view.isLastNameSet() )
    {
      setLastName( view.getLastName() );
    }
  }

  public Integer ejbCreate( ViewPerson view )
    throws CreateException
  {
    getPartyLocalHome().create(new ViewParty(view.getId(), "I"));
    setViewPerson( view );
    return null;
  }

  public void ejbPostCreate( ViewPerson view )
    throws CreateException
  {
    try
    {
      PartyLocal party = getPartyLocalHome().findByPrimaryKey(view.getId());
      setParty( party );
    }
    catch (FinderException e)
    {
      throw new EJBException( "Party not created" );
    }
  }
  

  public void ejbActivate() {}
  public void ejbLoad() {}
  public void ejbPassivate() {}
  public void ejbRemove() {}
  public void ejbStore() {}
  public void setEntityContext(EntityContext ctx) {}
  public void unsetEntityContext() {}
}