package hivemind.example.article;

import org.apache.hivemind.Registry;
import org.apache.hivemind.impl.RegistryBuilder;
import hivemind.example.article.service.RegistrationService;
import hivemind.example.article.exception.UserAlreadyExistsException;

/**
 * Main
 *
 * @author James Carman
 * @version 1.0
 */
public class Main
{
    public static void main( String[] args ) throws Exception
    {
        Registry registry = RegistryBuilder.constructDefaultRegistry();
        RegistrationService registrationService = ( RegistrationService ) registry.getService( RegistrationService.class );
        try
        {
            registrationService.registerUser( "user@localhost" );
        }
        finally
        {
            registry.cleanupThread();
            registry.shutdown();
        }
    }
}
