package hivemind.example.article.domain.factory.impl;

import hivemind.example.article.domain.entity.User;
import hivemind.example.article.domain.factory.UserFactory;
import hivemind.example.article.util.ImplementationObject;

import java.util.Random;

/**
 *
 * @author James Carman
 * @version 1.0
 */
public class UserFactoryImpl extends ImplementationObject implements UserFactory
{
//******************************************************************************
// Fields
//******************************************************************************

    private Random random = new Random();


//******************************************************************************
// Interface UserFactory
//******************************************************************************

    public User createUser( String emailAddress )
    {
        final User user = new User();
        user.setEmailAddress( emailAddress );
        user.setPassword( "password" + random.nextInt() );
        return user;
    }
}

