package hivemind.example.article.domain.repository.impl;

import hivemind.example.article.domain.repository.UserRepository;
import hivemind.example.article.domain.entity.User;
import org.hibernate.Session;
import org.hibernate.Query;

/**
 * @author James Carman
 * @version 1.0
 */
public class HibernateUserRepository implements UserRepository
{
//******************************************************************************
// Fields
//******************************************************************************

    private Session session;

//******************************************************************************
// Getters/Setters
//******************************************************************************

    public void setSession( Session session )
    {
        this.session = session;
    }

//******************************************************************************
// Interface UserRepository
//******************************************************************************


    public User getUserByEmailAddress( String emailAddress )
    {
        final Query query = session.createQuery( "select u from User u where u.emailAddress = ?" );
        query.setString( 0, emailAddress );
        return ( User )query.uniqueResult();
    }

    public void addUser( User user )
    {
        session.save( user );
    }
}

