package hivemind.example.article.hibernate;

import hivemind.example.article.service.TransactionService;
import org.hibernate.Session;
import org.hibernate.Transaction;

/**
 * @author James Carman
 * @version 1.0
 */
public class HibernateTransactionService implements TransactionService
{
//******************************************************************************
// Fields
//******************************************************************************

    private boolean rollbackOnly;
    private Session session;
    private Transaction transaction;

//******************************************************************************
// Getters/Setters
//******************************************************************************

    public boolean isRollbackOnly()
    {
        return rollbackOnly;
    }

    public void setSession( Session session )
    {
        this.session = session;
    }

//******************************************************************************
// Interface TransactionService
//******************************************************************************


    public void setRollbackOnly()
    {
        rollbackOnly = true;
    }

    public boolean isActive()
    {
        return transaction != null;
    }

    public void begin()
    {
        transaction = session.beginTransaction();
        rollbackOnly = false;
    }

    public void commit()
    {
        transaction.commit();
        transaction = null;
    }

    public void rollback()
    {
        transaction.rollback();
        transaction = null;
    }
}

