package hivemind.example.article.interceptor;

import hivemind.example.article.service.TransactionService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;

/**
 * @author James Carman
 * @version 1.0
 */
public class TransactionInterceptor implements MethodInterceptor
{
//******************************************************************************
// Fields
//******************************************************************************

    private TransactionService transactionService;
    private Log log;

//******************************************************************************
// Getters/Setters
//******************************************************************************

    public void setLog( Log log )
    {
        this.log = log;
    }

    public void setTransactionService( TransactionService transactionService )
    {
        this.transactionService = transactionService;
    }

//******************************************************************************
// Interface MethodInterceptor
//******************************************************************************

    public Object invoke( MethodInvocation methodInvocation ) throws Throwable
    {
        if( transactionService.isActive() )
        {
            return proceedWithInvocation( methodInvocation );
        }
        else
        {
            try
            {
                log.debug( "Beginning transaction..." );
                transactionService.begin();
                return proceedWithInvocation( methodInvocation );
            }
            finally
            {
                if( transactionService.isRollbackOnly() )
                {
                    log.debug( "Rolling back transaction..." );
                    transactionService.rollback();
                }
                else
                {
                    log.debug( "Committing transaction..." );
                    transactionService.commit();
                }
            }
        }
    }

//******************************************************************************
// Other Methods
//******************************************************************************

    private Object proceedWithInvocation( MethodInvocation methodInvocation ) throws Throwable
    {
        try
        {
            return methodInvocation.proceed();
        }
        catch( RuntimeException e )
        {
            transactionService.setRollbackOnly();
            throw e;
        }
    }
}

