package hivemind.example.article.service.impl;

import hivemind.example.article.domain.factory.UserFactory;
import hivemind.example.article.domain.repository.UserRepository;
import hivemind.example.article.domain.entity.User;
import hivemind.example.article.exception.UserAlreadyExistsException;
import hivemind.example.article.service.RegistrationService;
import hivemind.example.article.service.EmailService;
import hivemind.example.article.util.ImplementationObject;

/**
 * RegistrationServiceImpl
 *
 * @author James Carman
 * @version 1.0
 */
public class RegistrationServiceImpl extends ImplementationObject implements RegistrationService
{
    private UserRepository userRepository;
    private UserFactory userFactory;
    private EmailService emailService;

    public void registerUser( String emailAddress ) throws UserAlreadyExistsException
    {
        if( userRepository.getUserByEmailAddress( emailAddress ) == null )
        {
            final User user = userFactory.createUser( emailAddress );
            userRepository.addUser( user );
            emailService.sendEmail( emailAddress, "Account Registration", "Your new account password is \"" + user.getPassword() + "\"." );
        }
        else
        {
            throw new UserAlreadyExistsException();
        }
    }

    public void setUserFactory( UserFactory userFactory )
    {
        this.userFactory = userFactory;
    }

    public void setUserRepository( UserRepository userRepository )
    {
        this.userRepository = userRepository;
    }

    public void setEmailService( EmailService emailService )
    {
        this.emailService = emailService;
    }
}
