package hivemind.example.article.service.impl;

import hivemind.example.article.domain.entity.User;
import hivemind.example.article.domain.factory.UserFactory;
import hivemind.example.article.domain.repository.UserRepository;
import hivemind.example.article.exception.UserAlreadyExistsException;
import hivemind.example.article.service.EmailService;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;

/**
 * @author James Carman
 * @version 1.0
 */
public class TestRegistrationServiceImpl extends MockObjectTestCase
{
//******************************************************************************
// Fields
//******************************************************************************

    public static final String EMAIL_ADDRESS = "foo@localhost";
    public static final String PASSWORD = "password";

//******************************************************************************
// Other Methods
//******************************************************************************

    public void testRegisterUser()
    {
        // Training...
        final Mock userRepositoryMock = mock( UserRepository.class );
        final Mock userFactoryMock = mock( UserFactory.class );
        final Mock emailServiceMock = mock( EmailService.class );
        final User user = new User();
        user.setEmailAddress( EMAIL_ADDRESS );
        user.setPassword( PASSWORD );
        userRepositoryMock.expects( once() ).method( "getUserByEmailAddress" ).with( eq( EMAIL_ADDRESS ) ).will( returnValue( null ) );
        userFactoryMock.expects( once() ).method( "createUser" ).with( eq( EMAIL_ADDRESS ) ).will( returnValue( user ) );
        userRepositoryMock.expects( once() ).method( "addUser" ).with( eq( user ) );
        emailServiceMock.expects( once() ).method( "sendEmail" ).with( eq( EMAIL_ADDRESS ), eq( "Account Registration" ), eq( "Your new account password is \"" + PASSWORD + "\"." ) );

        // Inject dependencies...
        final RegistrationServiceImpl impl = new RegistrationServiceImpl();
        impl.setUserRepository( ( UserRepository ) userRepositoryMock.proxy() );
        impl.setUserFactory( ( UserFactory ) userFactoryMock.proxy() );
        impl.setEmailService( ( EmailService ) emailServiceMock.proxy() );
        
        // Test logic...
        try
        {
            impl.registerUser( EMAIL_ADDRESS );
        }
        catch( UserAlreadyExistsException e )
        {
            fail();
        }
    }

    public void testRegisterExistingUser()
    {
        // Training...
        final Mock userRepositoryMock = mock( UserRepository.class );
        final User user = new User();
        user.setEmailAddress( EMAIL_ADDRESS );
        user.setPassword( PASSWORD );
        userRepositoryMock.expects( once() ).method( "getUserByEmailAddress" ).with( eq( EMAIL_ADDRESS ) ).will( returnValue( user ) );
        userRepositoryMock.expects( never() ).method( "addUser" );

        // Inject dependencies...
        final RegistrationServiceImpl impl = new RegistrationServiceImpl();
        impl.setUserRepository( ( UserRepository ) userRepositoryMock.proxy() );

        // Test logic...
        try
        {
            impl.registerUser( EMAIL_ADDRESS );
            fail();
        }
        catch( UserAlreadyExistsException e )
        {
        }
    }
}