/*
 * @author Phil Zoio
 */
package co.uk.realsolve.holiday.components;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;

/**
 * Component to handle redirects. Create Javascript element which allows a
 * redirect, and use the external service to generate a link which contains the
 * service parameters
 */
public class Redirect extends AbstractComponent
{

    private String targetPage;

    private Object[] parameters;

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle)
    {
        writer.begin("SCRIPT");
        ILink link = getLink(cycle, Tapestry.EXTERNAL_SERVICE);
        writer.printRaw("window.location.replace(\"" + link.getURL() + "\");");
        writer.end();
    }

    protected ILink getLink(IRequestCycle cycle, String serviceName)
    {
        IEngineService service = cycle.getEngine().getService(serviceName);
        Object[] serviceParameters = null;
        if (parameters == null)
        {
            serviceParameters = new Object[]
            {
                targetPage
            };
        }
        else
        {
            serviceParameters = new Object[parameters.length + 1];
            System.arraycopy(parameters, 0, serviceParameters, 1, parameters.length);
            serviceParameters[0] = targetPage;
        }
        return service.getLink(cycle, this, serviceParameters);
    }

    public String getTargetPage()
    {
        return targetPage;
    }

    public void setTargetPage(String newPage)
    {
        this.targetPage = newPage;
    }

    public Object[] getParameters()
    {
        return parameters;
    }

    public void setParameters(Object[] parameters)
    {
        this.parameters = parameters;
    }
}