package co.uk.realsolve.holiday.pages;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;

import co.uk.realsolve.holiday.beans.HolidayBooking;
import co.uk.realsolve.holiday.shared.HolidayService;
import co.uk.realsolve.holiday.shared.HolidaySession;
import co.uk.realsolve.holiday.tapestry.Visit;

public class HolidayDetails extends BaseApplicationPage implements IExternalPage
{

    // the service attached to the ServletContext
    private HolidayService service;

    private HolidayBooking currentHolidayBooking;

    private String message;

    /** ********** event handlers *********** */

    public void initialize()
    {
        currentHolidayBooking = null;
        message = null;
    }

    public void activateExternalPage(Object[] parameters, IRequestCycle cycle)
    {

        // we can do this ...
        Visit visit = (Visit) cycle.getEngine().getVisit(cycle);
        HolidaySession session = visit.getHolidaySession();
        HolidayBooking currentHolidayBooking = session.getCurrentHolidayBooking();

        // or we could do this ...
        Integer holidayID = (Integer) parameters[0];
        HolidayBooking holiday = service.getHoliday(holidayID.intValue());

        if (holiday != null)
        {
            setCurrentHolidayBooking(currentHolidayBooking);
        }
        else
        {
            setMessage("No current physical holiday matches ID supplied ");
        }

    }

    /** ********** getters and setters *********** */

    public HolidayService getService()
    {
        return service;
    }

    public void setService(HolidayService service)
    {
        this.service = service;
    }

    public String getMessage()
    {
        return message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }

    public HolidayBooking getCurrentHolidayBooking()
    {
        return currentHolidayBooking;
    }

    public void setCurrentHolidayBooking(HolidayBooking currentHolidayBooking)
    {
        this.currentHolidayBooking = currentHolidayBooking;
    }
}