package co.uk.realsolve.holiday.pages;

import java.util.List;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;

import co.uk.realsolve.holiday.beans.HolidayBooking;
import co.uk.realsolve.holiday.shared.HolidayService;
import co.uk.realsolve.holiday.shared.HolidaySession;
import co.uk.realsolve.holiday.tapestry.Visit;

public class Home extends BaseApplicationPage implements PageRenderListener, IExternalPage
{

    /** ********** fields *********** */

    // the service attached to the ServletContext
    private HolidayService service;

    // user message to output
    private String message;

    // all the physical holidays
    private List holidayBookings;

    // the current physical holiday when you're cycling through a ForEach
    private HolidayBooking currentHolidayBooking;

    // the selected physicalHoliday
    private HolidayBooking holidayChoice;

    /** ********** event handlers *********** */

    public void initialize()
    {
        message = null;
        holidayBookings = null;
        currentHolidayBooking = null;
        holidayChoice = null;
    }

    public void pageBeginRender(PageEvent event)
    {
        holidayBookings = service.getHolidayBookings();
    }

    public void activateExternalPage(Object[] parameters, IRequestCycle cycle)
    {
    }

    /** ********** form handlers *********** */

    public void detailsSubmit(IRequestCycle cycle)
    {
        if (!checkForSelection())
        {
            return;
        }

        // can store in the session, otherwise we'd have to put it in the URL
        Visit visit = (Visit) cycle.getEngine().getVisit(cycle);
        HolidaySession session = visit.getHolidaySession();
        session.setCurrentHolidayBooking(holidayChoice);

        // or ...
        Redirect redirect = (Redirect) cycle.getPage("Redirect");
        redirect.setTargetPage("HolidayDetails");
        redirect.setParameters(new Object[]
        {
            new Integer(holidayChoice.getHolidayID())
        });

        cycle.activate(redirect);
        return;
    }

    public void newSubmit(IRequestCycle cycle)
    {
        Redirect redirect = (Redirect) cycle.getPage("Redirect");
        redirect.setTargetPage("NewHoliday");
        cycle.activate(redirect);
        return;
    }

    public void deleteSubmit(IRequestCycle cycle)
    {
        if (!checkForSelection())
        {
            return;
        }

        service.deleteHoliday(holidayChoice);

        Redirect redirect = (Redirect) cycle.getPage("Redirect");
        redirect.setTargetPage("Home");
        cycle.activate(redirect);
        return;
    }

    /** ********** helper methods *********** */

    private boolean checkForSelection()
    {

        if (holidayChoice == null)
        {
            setMessage("Please select a holiday");
            return false;
        }

        return true;
    }

    /** ********** getters and setters *********** */

    public HolidayBooking getCurrentHolidayBooking()
    {
        return currentHolidayBooking;
    }

    public void setCurrentHolidayBooking(HolidayBooking currentHolidayBooking)
    {
        this.currentHolidayBooking = currentHolidayBooking;
    }

    public HolidayBooking getHolidayChoice()
    {
        return holidayChoice;
    }

    public void setHolidayChoice(HolidayBooking holidayChoice)
    {
        this.holidayChoice = holidayChoice;
    }

    public List getHolidayBookings()
    {
        return holidayBookings;
    }

    public void setHolidayBookings(List holidayBookings)
    {
        this.holidayBookings = holidayBookings;
    }

    public HolidayService getService()
    {
        return service;
    }

    public void setService(HolidayService service)
    {
        this.service = service;
    }

    public String getMessage()
    {
        return message;
    }

    public void setMessage(String message)
    {
        this.message = message;
    }
}