package co.uk.realsolve.holiday.pages;

import java.util.Arrays;
import java.util.Date;

import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

import co.uk.realsolve.holiday.shared.HolidayService;

public class NewHoliday extends BaseApplicationPage implements IExternalPage, PageRenderListener
{

    /** ********** fields *********** */

    // the service attached to the ServletContext
    private HolidayService service;

    // form input fields amount, date, description, reference
    private Float amount;

    private Date date;

    private String description;

    /** ********** event handlers *********** */

    public void initialize()
    {
        amount = null;
        date = null;
        description = null;
    }

    public void activateExternalPage(Object[] parameters, IRequestCycle cycle)
    {
        if (parameters != null)
            System.out.println("Parameters: " + Arrays.asList(parameters));
    }

    public void pageBeginRender(PageEvent event)
    {
        System.out.println("PageEvent: " + event);
    }

    /** ********** form handlers *********** */

    public void addSubmit(IRequestCycle cycle)
    {

        // handle validation
        IValidationDelegate delegate = (IValidationDelegate) getBeans().getBean("delegate");

        // validate date, because we don't know user hasn't put rubbish in text
        // box
        if (!validateDate(cycle, delegate))
            return;

        if (delegate.getHasErrors())
        {
            return;
        }

        float floatValue = amount.floatValue();
        service.addHoliday(floatValue, date, description);
        System.out.println("Added new details");
        Redirect redirect = (Redirect) cycle.getPage("Redirect");
        redirect.setTargetPage("Home");
        cycle.activate(redirect);
        return;
    }

    /** ********** validate date *********** */

    private boolean validateDate(IRequestCycle cycle, IValidationDelegate delegate)
    {
        Date date = getDate();
        if (date == null)
        {
            IFormComponent formComponent = (IFormComponent) getComponent("inputDate");
            delegate.setFormComponent(formComponent);
            delegate.record("Date must be selected", ValidationConstraint.DATE_FORMAT);
            return false;
        }
        return true;
    }

    /** ********** helper methods *********** */

    public Float getAmount()
    {
        return amount;
    }

    public void setAmount(Float amount)
    {
        this.amount = amount;
    }

    public Date getDate()
    {
        return date;
    }

    public void setDate(Date date)
    {
        this.date = date;
    }

    public String getDescription()
    {
        return description;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    public HolidayService getService()
    {
        return service;
    }

    public void setService(HolidayService service)
    {
        this.service = service;
    }
}