/*
 * @author Phil Zoio
 */
package co.uk.realsolve.holiday.shared;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import co.uk.realsolve.holiday.beans.DayCount;
import co.uk.realsolve.holiday.beans.HolidayBooking;

/**
 * Represents service interface to backend, only one single copy since stored in
 * context
 */
public class HolidayServiceImpl implements HolidayService
{

    private List holidayBookings;

    static int id;

    public HolidayServiceImpl()
    {

        List holidayBooking = getHolidayBookings();

        if (holidayBooking == null)
        {
            holidayBooking = new ArrayList();
            setHolidayBookings(holidayBooking);

            addHoliday(11.0F, new java.util.Date(), null);
            addHoliday(22.12F, new java.util.Date(), null);
        }
    }

    /** *************** public service methods ******************* */

    public List getHolidayBookings()
    {
        return holidayBookings;
    }

    public void addHoliday(float f, Date date, String description)
    {
        long currentTime = date.getTime();

        HolidayBooking holiday = new HolidayBooking();
        holiday.setHolidayID(++id);
        holiday.setAmount(new DayCount(f));
        holiday.setDate(new Timestamp(currentTime));

        if (description == null)
            description = "Holiday no " + id;
        holiday.setDescription(description);
        holidayBookings.add(holiday);
    }

    public void deleteHoliday(HolidayBooking currentHolidayBooking)
    {
        for (Iterator iter = holidayBookings.iterator(); iter.hasNext();)
        {
            HolidayBooking holiday = (HolidayBooking) iter.next();
            if (holiday.getHolidayID() == currentHolidayBooking.getHolidayID())
            {
                iter.remove();
                break;
            }

        }
    }

    public HolidayBooking getHoliday(int holidayID)
    {
        for (Iterator iter = holidayBookings.iterator(); iter.hasNext();)
        {
            HolidayBooking holiday = (HolidayBooking) iter.next();
            if (holiday.getHolidayID() == holidayID)
            {
                return holiday;
            }
        }
        return null;
    }

    /** *************** helper methods ******************* */

    /**
     * Allows you to add a holiday
     */
    private void addHoliday(float f, String ref)
    {
        Date date = new Date();
        addHoliday(f, date, null);
    }

    protected void setHolidayBookings(List physicalHolidays)
    {
        this.holidayBookings = physicalHolidays;
    }

}