


import        java.io.File;
import        java.io.RandomAccessFile;
import        java.util.Random;

import static java.lang.Math.*;
import static java.lang.System.out;
import static java.lang.System.currentTimeMillis;


public class DiskIOTest extends Object {
  // Symbolic constants
  final static private String     FILE_NAME  = "./disk_io_test.bin";
  final static private int        RECORD_LEN = 17,
                                  RECORD_NUM = 7895161;


  // Private and protected members

  private static void displaySystemInfo() {
    System.out.printf( "%s %s %s\nJava %s\n",
                       System.getProperty("os.name"),
                       System.getProperty("os.version"),
                       System.getProperty("os.arch"),
                       System.getProperty("java.version")
                     );
  } // displaySystemInfo


  private static long createFile() throws Exception {
    byte[]              byRecord = new byte[RECORD_LEN];
    long                lEndTime,
                        lStartTime = currentTimeMillis();
    RandomAccessFile    file   = new RandomAccessFile(FILE_NAME, "rw");

    for (int nLoop = 0x00;nLoop < RECORD_LEN;nLoop++)
      byRecord[nLoop] = 0x45;

    file.setLength(0x00L);
    file.close();

    file = new RandomAccessFile(FILE_NAME, "rw");
    for (int nLoop = 0x00;nLoop < RECORD_NUM;nLoop++) 
      file.write(byRecord);

    file.close();

    lEndTime = currentTimeMillis();

    return lEndTime-lStartTime;
  } // createFile


  private static long readCompleteFile() throws Exception {
    byte[]              byRecord = new byte[RECORD_LEN];
    long                lEndTime,
                        lStartTime = currentTimeMillis();
    RandomAccessFile    file   = new RandomAccessFile(FILE_NAME, "rw");

    for (int nLoop = 0x00;nLoop < RECORD_NUM;nLoop++)
      file.read(byRecord);

    file.close();
    lEndTime = currentTimeMillis();

    return lEndTime-lStartTime;
  } // readCompleteFile


  private static long randomReadWrite() throws Exception {
    long                lEndTime,
                        lStartTime = currentTimeMillis(),
                        lOffset;
    RandomAccessFile    file     = new RandomAccessFile(FILE_NAME, "rw");
    Random              r        = new Random(0x992008L);
    byte[]              byRecord = new byte[RECORD_LEN],
                        byUpdate = new byte[RECORD_LEN];

    for (int nLoop = 0x00;nLoop < RECORD_LEN;nLoop++)
      byUpdate[nLoop] = 0x58;

    for (int nLoop = 0x00;nLoop < RECORD_NUM;nLoop++) {
      lOffset = (abs(r.nextInt())%RECORD_NUM)*RECORD_LEN;
      file.seek(lOffset);
      file.read(byRecord, 0x00, byRecord.length);
      file.write(byUpdate, 0x00, byRecord.length);
    }
    file.close();

    lEndTime = currentTimeMillis();

    return lEndTime-lStartTime;
  } // randomReadWrite


  // Public methods
  public static void main(String...      argV) {
    long           lCreateFileTime,
                   lReadFileTime,
                   lReadWriteTime;
    File           file;

    try {
      lCreateFileTime = createFile();
      lReadFileTime   = readCompleteFile();
      lReadWriteTime  = randomReadWrite();

      file = new File(FILE_NAME);
      out.println("*** Disk I/O Test ***");
      displaySystemInfo();
      out.println("File name:         "+FILE_NAME);
      out.println("File length (MB)   "+file.length()/0x100000);
      out.println("Create time (ms):  "+lCreateFileTime);
      out.println("Read time (ms):    "+lReadFileTime);
      out.println("Read/write time (ms):  "+lReadWriteTime);

      // Keep FILE_NAME if the argument list is not empty;
      // useful for debugging.
      if (argV.length == 0x00)
        file.delete();
    }
    catch (Exception e) {
      // If something goes wrong, force exit and price stack trace.
      e.printStackTrace();
      System.exit(-1);
    }

    System.exit(0);
  } // main
} // DiskIOTest

