


#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>


typedef struct {
  int         nLeft, nRight;
} Node; /* Node */


static Node        stack[512];
static int         SAMPLE_SIZE = 0;


void readSample(int     nSample[]) {
  char             *szSample = malloc(64*sizeof(char));
  int              nPtr      = 0;

  while (fgets(szSample, 64, stdin) != NULL)
    nSample[nPtr++] = strtol(szSample, NULL, 10);

  free(szSample);
} /* readSample */


void quickSort(int      *nSample) {
    int            nItemPointer,
                   nAnoterItemPointer,
                   nLeft,
                   nRight,
                   nStackPtr = 0x00;
    int            nCurrentSample,
                   nBubble;

    stack[0x00].nLeft  = 0x00;
    stack[0x00].nRight = SAMPLE_SIZE-0x01;
    do {
      nLeft  = stack[nStackPtr].nLeft;
      nRight = stack[nStackPtr--].nRight;
      do {
        nItemPointer       = nLeft;
        nAnoterItemPointer = nRight;
        nCurrentSample     = nSample[(nLeft+nRight)/0x02];
        do {
          while (nSample[nItemPointer] < nCurrentSample)
            nItemPointer++;
          while (nSample[nAnoterItemPointer] > nCurrentSample)
            nAnoterItemPointer--;
          if (nItemPointer <= nAnoterItemPointer) {
            nBubble                       = nSample[nItemPointer];
            nSample[nItemPointer++]       = nSample[nAnoterItemPointer];
            nSample[nAnoterItemPointer--] = nBubble;
          }
        } while (nItemPointer <= nAnoterItemPointer);
        if (nItemPointer < nRight) {
          stack[++nStackPtr].nLeft = nItemPointer;
          stack[nStackPtr].nRight  = nRight;
        }
        nRight = nAnoterItemPointer;
      } while (nLeft < nRight);
    } while (nStackPtr != -1);
} /* quickSort */


int main(int       nArgC,
         char      **szArgV) {

  int              nLoop;
  int              *nSample    = NULL;
  struct timeval   timeStart,
                   timeEnd,
                   timeLapsed;

  SAMPLE_SIZE = strtol(szArgV[1], NULL, 10);
  nSample     = malloc(SAMPLE_SIZE*sizeof(int));
  readSample(nSample);
  
  gettimeofday(&timeStart, NULL);
  quickSort(nSample);
  gettimeofday(&timeEnd, NULL);
  free(nSample);

  printf("*** Native Quicksort Results ***\n");
  printf("Number of elements in sample: %d\n", SAMPLE_SIZE);
  
  if (timeStart.tv_usec > timeEnd.tv_usec) {
    timeEnd.tv_usec += 1000000;
    timeEnd.tv_sec--;
  }
  timeLapsed.tv_usec = timeEnd.tv_usec-timeStart.tv_usec;
  timeLapsed.tv_sec  = timeEnd.tv_sec-timeStart.tv_sec;

  printf("Time to sort (seconds): %d%03d\n", timeLapsed.tv_sec, timeLapsed.tv_usec/1000);

  return 0x00;
} // main

