class BitSet
{	int P[];
	int K;
	public BitSet (int k)
	{	P=new int[k/32+1]; K=k;
	}
	synchronized public void set (int i)
	{	if (i<0) throw new ArrayIndexOutOfBoundsException("");
		P[i>>5]|=(1<<(i&0x0000001F));
	}
	synchronized public void clear (int i)
	{	P[i>>5]&=~(1<<(i&0x0000001F));
	}
	synchronized public boolean get (int i)
	{	return (P[i>>5]&(1<<(i&0x0000001F)))!=0;
	}
	public int size ()
	{	return K;
	}
}
	
	
/* Sieve.java
Das Primzahlsieb fr Java.
*/

public class SieveBits
{	static BitSet prime;
	// Enthaelt Flags fuer die ungeraden Zahlen:
   // 3,5,7,...
   // D.h., 2*i+3 ist prim, wenn prime[i] war ist
   
	static public void main (String args[])
    // Hauptprogramm
    {	int n;
		if (args.length==0) n=100000000;
		// falls keine Argumente in der Kommandozeile
		else n=Integer.parseInt(args[0]);
		// lies Anzahl aus der Kommandozeile
		int k=(n-3)/2;
		System.out.println("Counting primes up to "+(2*k+3)+".");
		long time=System.currentTimeMillis();
		prime=new BitSet(k);
        sieve(); // das Sieb
		// Zaehle gefundene Primzahlen:
		int count=1,i;
		for (i=0; i<k; i++)
			if (prime.get(i)) count++;
		// Ausgabe:
		time=System.currentTimeMillis()-time;
		System.out.println(count+" primes found.");
		System.out.println(time/1000+" seconds needed");
		// list(); // nur fuer Testzwecke
	}
   
	static void sieve ()
	// das Sieb
	{	int k=prime.size(),i,j,p,l;
		// Zuerst alle Zahlen auf prim setzen
		for (i=0; i<k; i++) prime.set(i);
		// Dann Vielfache von Primzahlen aussieben
		for (i=0; i<k; i++)
		{  
			if (prime.get(i)) // 2*i+3 ist prim
			{	p=2*i+3;
				l=(p*p-3)/2;
				if (l>k) break;
				for (j=l; j<k; j+=p) prime.clear(j);
				// streicht p*p,p*(p+2), etc.
			}
		}
	}

}
