package ontocentric.persistence;

import ontocentric.sliceable.SliceablePerson;
import ontocentric.model.Person;


public class PersistentPerson extends SliceablePerson {

    // not present in superclass
    public PersistentPerson(String s) {
        name = s;
    }

    // overriden method
    public String getName() {
        return name.toUpperCase();
    }

    public void setName(String s) {
        String oldName = name;
        name = s;
        try {
            dbStore();
        } catch (Exception e) {
            name = oldName;
            System.out.println("Update failed: " + e.getMessage());
        }
    }
    // not present in superclass
    public void setId(int i) {
        id = i;
    }

    //persistence methods

    private static java.util.Map fakeDB = new java.util.HashMap();
    public void dbCreate() throws Exception {
        //... JDBC code
        fakeDB.put(new Integer(id), this);
        System.out.println("Creating Person: " + getName() + ", " + getId());
    }

    public void dbStore() throws Exception {
        //... JDBC code
        if (name == null) {
            throw new Exception("Cannot store a person without a name");
        }
        fakeDB.put(new Integer(id), this);
        System.out.println("Storing Person: " + getName() + ", " + getId());
    }

    public void dbLoad()  throws Exception  {
        //... JDBC code
        name = ((PersistentPerson) fakeDB.get(new Integer(id))).asPerson().getName();
        System.out.println("Loading Person: " + getName() + ", " + getId());
    }

    public void dbRemove()  throws Exception  {
        //... JDBC code
        fakeDB.remove((new Integer(id)));
        System.out.println("Removing Person: " + getName() + ", " + getId());
    }

    // read only slice
    private class ROPersonSlice extends PersonSlice {
        public void setName(String s) {
            throw new RuntimeException("You are not allowed to change the name");
        }
    }

    // get a read only slice
    public final Person asROPerson() {
        return new ROPersonSlice();
    }
}
