package ontocentric.repository;

import ontocentric.model.Person;
import ontocentric.persistence.PersistentPerson;

import java.util.Random;



public class PersonRepository {

    private static Random rand = new Random(-17);

    public static Person createPerson(String name) throws Exception {
        PersistentPerson pp = new PersistentPerson(name);
        pp.setId(rand.nextInt());
        pp.dbCreate();
        return pp.asStoredPerson();
    }

    public static Person getPerson(int id) throws Exception {
        PersistentPerson pp = new PersistentPerson(null);
        pp.setId(id);
        pp.dbLoad();
        return pp.asStoredPerson(); // object slicing
    }
}
