package ontocentric.sliceable;

import ontocentric.model.Person;

public abstract class SliceablePerson extends Person {
    //slice
    protected class PersonSlice extends Person {


        public String getName() {
            return SliceablePerson.super.getName();
        }

        public void setName(String s) {
            SliceablePerson.super.setName(s);
        }

        public int getId() {
            return SliceablePerson.super.getId();
        }
    }

    // get the slice
    public final Person asPerson() {
        return new PersonSlice();
    }


    // stored person slice
    private class StoredPersonSlice extends PersonSlice {
        public void setName(String s) {
            SliceablePerson.this.setName(s);
        }
    }

    // get a stored person slice
    public final Person asStoredPerson() {
        return new StoredPersonSlice();
    }
}
