package ontocentric.test;

import ontocentric.persistence.PersistentPerson;
import ontocentric.model.Person;
import ontocentric.repository.PersonRepository;

public class Test {

    public static void main(String[] args) throws Exception {

        PersistentPerson pp = new PersistentPerson("George");
        System.out.println(pp.getName()); // GEORGE

        // get the slice
        Person p = pp.asPerson();
        System.out.println(p.getName()); // George

        // changes in the whole are reflected in the slice
        pp.setName("Lisa");
        System.out.println(p.getName()); // Lisa

        // changes in the slice are reflected in the whole
        p.setName("Michael");
        System.out.println(pp.getName()); // MICHAEL

        // for read only version override setter to throw
        Person rop = pp.asROPerson();
        System.out.println(rop.getName()); // Michael
        try {
            rop.setName("Paul");
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage()); // You are not allowed to change the name.
        }

        // using the repository
        p = PersonRepository.createPerson("Claudia"); // Creating Person: CLAUDIA, 1148943844
        System.out.println(p.getName() + ", " + p.getId()); // Claudia, 1148943844

        //changing the name triggers the storage of the object
        p.setName("Claudia Maria"); // Storing Person: CLAUDIA MARIA, 1148943844
        p = PersonRepository.getPerson(p.getId()); // Loading Person: CLAUDIA MARIA, 1148943844
        System.out.println(p.getName()); // Claudia Maria

        p.setName(null); // Update failed: Cannot store a person without a name
        System.out.println(p.getName()); // Claudia Maria
    }

}
