package slicing.test;

import slicing.base.Base;
import slicing.derived.Derived;

public class Test {

    public static void main(String[] args) {
        Base base = null;

        Derived derived = new Derived();
        System.out.println(derived.sayHello()); // HELLO.

        //casting does not do slicing
        base = (Base) derived;
        System.out.println(base.sayHello()); // HELLO.

        //the slice has only the base part
        base = derived.getSuper();
        System.out.println(base.sayHello()); // Hello.

        //the whole and the slice are in synch
        derived.setGreeting("Hi.");
        System.out.println(base.sayHello()); // Hi.
    }
}
