package EJBObserverPattern;

/**
 * A class can implement the Observer interface when it wants to be informed
 * of changes in observable objects.
 */
public interface EJBObserver
{
    /**
     * This method is called whenever the observed object is changed.
     * An application calls an Observable object's notifyObservers method
     * to have all the object's observers notified of the change.
     * <p>A remote EJB which implements this interface will be enlisted in
     * the current transaction when its update method is invoked. To abort
     * the transaction the EJB must either 1) throw RemoteException or RuntimeException
     * or any subclass thereof (these are known as <i>system exceptions</i>,
     * or 2) invoke setRollbackOnly on its EJBContext
     * object.
     *
     * @param       observable  a reference to the object being observed
     * @param       arg         the arguments being passed to the observer
     * @exception   RemoteException
     * @exception   EJBException
     *
     */
    public void update (EJBObservable object, Object arg)
        throws  java.rmi.RemoteException, javax.ejb.EJBException;

}