package EJBObserverPattern;

public class Foobar extends EJBObservable
{
    String mSomething = null;

    public void setSomething (String s)
    {
        mSomething = s;
        setChanged (true);

        /*  We could call notifyObservers right here, but this may or may not
            be a good thing to do. Each call to notifyObservers will result in
            a remote method call for every registered observer. If there is
            more than one attribute to 'set' then it might be better
            for the caller to set them all and then call notifyObservers explicitly.
        */
    }

    public String toString ()
    {
        return mSomething;
    }
}
