/*
Copyright 2004 Matt Butcher

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package tv.aleph_null.opencms.velocity;

import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.Resource;

import com.opencms.file.CmsObject;
import com.opencms.file.CmsFile;

/**
 * Creates a resource loader capable of reading files from the CMS.
 * This class is largely modeled upon Velocity's ClasspathResourceLoader.
 * <p>This is stubbed out for OpenCms 6.0, but since there is no CmsObject
 * for us to get in OpenCms 5.0.x, we can't create a ResourceLoader.</p>
 * @author M Butcher (mmbutcher@aleph-null.tv)
 * @see org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader
 */
public class CmsVelocityResourceLoader extends ResourceLoader {

	public CmsVelocityResourceLoader() {
		//NOOP
	}

	public long getLastModified(Resource res) {
		return 0;
	}

	public boolean isSourceModified(Resource res) {
		return false;
	}

	public void init(ExtendedProperties props) {
		// NOOP
	}

	public java.io.InputStream getResourceStream( String name ) {
		byte [] contents = {};
		// Create a CmsObject
		// Fetch the file's contents. File will be type plain.
		// Encapsulate the byte array in an InputStream.
		return new java.io.ByteArrayInputStream(contents);
	}

}
