package tv.aleph_null.opencms.velocity;

import java.util.Hashtable;
import java.io.StringWriter; //just for output.

import org.apache.velocity.app.Velocity;
import org.apache.velocity.VelocityContext;

/**
 * This class tests the velocity template engine. 
 * Basically, it is checking to see if we can pass Velocity the 
 * information it needs without really having to hack things up.
 * <p>To invoke:</p><xmp>java VelocityTest</xmp>
 */
public class VelocityTest {
	public static void main(String [] argv) {

		// We get content in a String:
		String content = "<p>This is the body content.</p>";

		// Properties are stored in a Hashtable.
		Hashtable fileProps = new Hashtable();
		fileProps.put("Title","My Test Article");
		fileProps.put("Description","My Test Article Description");

		VelocityContext ctx = new VelocityContext();
		ctx.put("props", fileProps);
		ctx.put("content", content);

		// Template will probably come in the form of a char[]...
		String temp = "Contents: $content";

		// I guess we might also want the info object in there.... but not now.

		// Dummy output writer:
		StringWriter out = new StringWriter();

		// OK... now we need to set up Velocity:
		try {
			Velocity.init();
			Velocity.evaluate( ctx, out, "FOO", temp);

			System.out.print(out.getBuffer().toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
