package example;

/**
 * Checks whether the user's income is above average.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public class HighIncomeRule implements BusinessRule {

    public boolean isConditionTrue(ProblemState s) {
        System.out.println(" \n HighIncomeRule condition is checked");
        // Do nothing if the income category has already been set
        if (s.getIncomeCategory() != null) return false;
        int averageIncome = (s.immutState.getHiIncome() + s.immutState.getLoIncome()) / 2;
        // Does the user have an above average income?
        return (s.immutState.profile.getIncome() >= averageIncome);
    }

    public void doAction(ProblemState s) {
        System.out.println(" .: HighIncomeRule action executes");
        // Update the evaluation score
        s.setScore(s.getScore() + s.immutState.getHiValue());
        // Set the income category
        s.setIncomeCategory("Above Average");
        // Update the corresponding explanation
        String reason = " .: This user's income is above average\n";
        s.setReasonWhy(s.getReasonWhy() + reason);
    }
}
