package example;

/**
 * Checks whether the user has a high risk profile.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public class HighRiskRule implements BusinessRule {

    public boolean isConditionTrue(ProblemState s) {
        System.out.println(" \n HighRiskRule condition is checked");
        // Do nothing if the risk category has already been set
        if (s.getRiskCategory() != null) return false;
        // Does the user have a high risk profile?
        return (!s.immutState.profile.ownsHouse());
    }

    public void doAction(ProblemState s) {
        System.out.println(" .: HighRiskRule action executes");
        // Update the evaluation score
        s.setScore(s.getScore() + s.immutState.getLoValue());
        // Set the risk category
        s.setRiskCategory("High");
        // Update the corresponding explanation
        String reason = " .: This user can offer no guarantees\n";
        s.setReasonWhy(s.getReasonWhy() + reason);
    }
}
