package example;

/**
 * Checks whether the user has a low risk profile.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public class LowRiskRule implements BusinessRule {

    public boolean isConditionTrue(ProblemState s) {
        System.out.println(" \n LowRiskRule condition is checked");
        // Do nothing if the risk category has already been set
        if (s.getRiskCategory() != null) return false;
        // Does the user have a low risk profile?
        return (s.immutState.profile.ownsHouse());
    }

    public void doAction(ProblemState s) {
        System.out.println(" .: LowRiskRule action executes");
        // Update the evaluation score
        s.setScore(s.getScore() + s.immutState.getHiValue());
        // Set the risk category
        s.setRiskCategory("Low");
        // Update the corresponding explanation
        String reason = " .: This user can offer his house as a guarantee\n";
        s.setReasonWhy(s.getReasonWhy() + reason);
    }
}
