package example;

/**
 * Checks whether the user's income is below average.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public class LowIncomeRule implements BusinessRule {

    public boolean isConditionTrue(ProblemState s) {
        System.out.println(" \n LowIncomeRule condition is checked");
        // Do nothing if the income category has already been set
        if (s.getIncomeCategory() != null) return false;
        int averageIncome = (s.immutState.getHiIncome() + s.immutState.getLoIncome()) / 2;
        // Does the user have a below average income?
        return (s.immutState.profile.getIncome() < averageIncome);
    }

    public void doAction(ProblemState s) {
        System.out.println(" .: LowIncomeRule action executes");
        // Update the evaluation score
        s.setScore(s.getScore() + s.immutState.getLoValue());
        // Set the income category
        s.setIncomeCategory("Below Average");
        // Update the corresponding explanation
        String reason = " .: This user's income is below average\n";
        s.setReasonWhy(s.getReasonWhy() + reason);
    }
}
