package example;

import java.util.Observable;

/**
 * Keeps the problem state.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public class ProblemState extends Observable {

    // Income and risk category
    private String incomeCategory, riskCategory;

    // Score and credit
    private int score, credit;

    // The explanation of the decision making process
    private String reasonWhy;

    // Is this a final problem state?
    private boolean isFinal;

    // Immutable state
    public ImmutableState immutState;

    public ProblemState(ImmutableState i) {
        incomeCategory = null;
        riskCategory = null;
        score = 0;
        credit = 0;
        reasonWhy = " \nExplanation of the decision making process is:\n";
        isFinal = false;
        immutState = i;
    }

    // Public accessors
    public String getIncomeCategory() {
        return incomeCategory;
    }

    public void setIncomeCategory(String value) {
        incomeCategory = value;
    }

    public String getRiskCategory() {
        return riskCategory;
    }

    public void setRiskCategory(String value) {
        riskCategory = value;
    }

    public int getScore() {
        return score;
    }

    public void setScore(int value) {
        score = value;
        // This state change will trigger notifications!
        setChanged();
        notifyObservers();
    }

    public int getCredit() {
        return credit;
    }

    public void setCredit(int value) {
        credit = value;
    }

    public String getReasonWhy() {
        return reasonWhy;
    }

    public void setReasonWhy(String r) {
        reasonWhy = r;
    }

    public boolean isFinal() {
        return isFinal;
    }

    public void isFinal(boolean value) {
        isFinal = value;
    }

    public void display() {
        System.out.println(" \nCredit Report:\n");
        System.out.println(" Income category: " + incomeCategory);
        System.out.println(" Risk category: " + riskCategory);
        System.out.println(" Granted credit: US$ " + credit);
        System.out.println(reasonWhy);
    }
}
