package example;

/**
 * Derives the credit value from the score.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public class CreditGrantingRule implements BusinessRule {

    public boolean isConditionTrue(ProblemState s) {
        System.out.println(" \n CreditGrantingRule condition is checked");
        // Has the user profile been fully analyzed?
        return (s.getIncomeCategory() != null & s.getRiskCategory() != null);
    }

    public void doAction(ProblemState s) {
        // The final state has been reached
        s.isFinal(true);
        System.out.println(" .: CreditGranting action executes");
        // Set the granted credit value
        if (s.getScore() >= s.immutState.getHiScore()) {
            s.setCredit(s.immutState.getMaxCredit());
        }
        else {
            if (s.getScore() < s.immutState.getHiScore() &
                s.getScore() > s.immutState.getLoScore()) {
                s.setCredit(s.immutState.getMedCredit());
            }
            else {
                if (s.getScore() <= s.immutState.getLoScore()) {
                    s.setCredit(s.immutState.getMinCredit());
                }
            }
        }
    }
}
