package example;

import java.util.*;

/**
 * The abstract evaluator.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public abstract class Evaluator implements Runnable, Observer {

    protected ProblemState state;

    protected Vector ruleSet;

    protected boolean hasBeenUpdated;

    public Evaluator(ProblemState s) {
        state = s;
        state.addObserver(this);
        ruleSet = new Vector();
        hasBeenUpdated = true;
    }

    public void run() { // Runnable interface
        while (!state.isFinal()) {
            if (hasBeenUpdated) evaluateRuleSet();
        }
    }

    public void update(Observable obs, Object obj) { // Observer interface
        hasBeenUpdated = true;
    }

    protected void evaluateRuleSet() {
        synchronized(state) { // critical section begins
            // A very simple inference engine...
            for (Enumeration e = ruleSet.elements();e.hasMoreElements();) {
                BusinessRule rule = (BusinessRule) e.nextElement();
                // Polymorphic evaluation of each rule in the rule set:
                if (rule.isConditionTrue(state)) rule.doAction(state);
                // if doAction() executes and causes a state change then
                // all Observers will be notified
            }
            hasBeenUpdated = false;
        } // critical section ends
    }

    protected abstract void assertRuleSet();
}
