package example;

/**
 * Keeps the immutable part of the problem state.
 *
 * @author <a href="mailto:cristina@acm.org">Cristina Belderrain</a>
 */
public class ImmutableState {

    // Immutable values (got from a database or calculated elsewhere)
    // Highest and lowest reference income
    private int hiIncome, loIncome;

    // Maximum, medium and minimum credit value
    private int maxCredit, medCredit, minCredit;

    // High and low values to be added to the current score
    private int hiValue, loValue;

    // High and low scores
    private int hiScore, loScore;

    public UserProfile profile;

    public ImmutableState(int h, int l, int hV, int lV, UserProfile p) {
        hiIncome = h;
        loIncome = l;
        maxCredit = hiIncome / 4;
        medCredit = ((hiIncome + loIncome) / 2) / 4;
        minCredit = loIncome / 4;
        hiValue = hV;
        loValue = lV;
        hiScore = 2 * hiValue;
        loScore = 2 * loValue;
        profile = p;
    }

    // Public accessors
    public int getHiIncome() {
        return hiIncome;
    }

    public int getLoIncome() {
        return loIncome;
    }

    public int getMaxCredit() {
        return maxCredit;
    }

    public int getMedCredit() {
        return medCredit;
    }

    public int getMinCredit() {
        return minCredit;
    }

    public int getHiValue() {
        return hiValue;
    }

    public int getLoValue() {
        return loValue;
    }

    public int getHiScore() {
        return hiScore;
    }

    public int getLoScore() {
        return loScore;
    }
}
