<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html"/>


<xsl:template match="text()">
  <!-- xsl:param name="level"/ -->
  <xsl:choose>
    <xsl:when test="contains(., '&#xA;')">
      <xsl:call-template name="Line">
        <xsl:with-param name="data"><xsl:value-of select="."/></xsl:with-param>
        <!-- xsl:with-param name="level" select="$level"/ -->
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="."/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="Line">
  <xsl:param name="data"/>
  <!-- xsl:param name="level"/ -->
  <xsl:variable name="first">
    <xsl:choose>
      <xsl:when test="contains($data,'&#xA;')">
        <xsl:value-of select="substring-before($data,'&#xA;')"/>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="$data"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="rest">
    <xsl:value-of select="substring-after($data,'&#xA;')"/>
  </xsl:variable>

  <!-- xsl:call-template name="indent_20011403">
    <xsl:with-param name="level" select="$level"/>
  </xsl:call-template -->

  <xsl:value-of select="$first"/>
   
  <xsl:if test="not($rest='')">
    <br/>
    <xsl:call-template name="Line">
      <xsl:with-param name="data"><xsl:value-of select="$rest"/></xsl:with-param>
      <!-- xsl:with-param name="level" select="$level"/ -->
    </xsl:call-template>
  </xsl:if>
</xsl:template>


<xsl:template match="/">
  <xsl:choose>
    <xsl:when test="not(//*[local-name() = 'Body']/*[1]/*[1]/*)">
      <xsl:apply-templates select="//*[local-name() = 'Body']/*[1]/*[1]/node()"/>
    </xsl:when>
    <xsl:otherwise>
      <table border="1">
        <xsl:apply-templates select="//*[local-name() = 'Body']/*[1]/*[1]/node()"/>
      </table>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
<xsl:template match="*">
  <tr><th valign="top"><xsl:value-of select="name()"/></th>
  <td>
     <xsl:choose>
       <xsl:when test="not(*)">
         <xsl:apply-templates/>
       </xsl:when>
       <xsl:otherwise>
         <table border="1" width="100%">
          <xsl:apply-templates/>
	 </table>
       </xsl:otherwise>
     </xsl:choose>
  </td></tr>
</xsl:template>
</xsl:stylesheet>
