/********************************
* StockQuoteService service specific code
********************************/

eval(__readInJS('global/SOAPhelper.js'));
var deHREF = sh_readInXSLT('global/href-id.xsl');

var StockQuoteService_destinationURI = 'http://localhost:6060/StockQuoteService/';



function StockQuoteService_getAvailableStocks(id, callXslt) {
  var node = __getNodeForId(id);
  sh_printStartOfConnecting(node);
  var error = {
    isError : false,
    where : '',
    detail : null
  }
  var request = null;
  var response = null;
  error.isError = call();
  if (error.isError) {
    sh_errorCase(error);
  }

  function call() {
    var s = new sh_SOAPCall();
    s.destinationURI = StockQuoteService_destinationURI;
    s.actionURI = '';
    s.targetObjectURI = 'http://idoox.com/wasp/tools/java2wsdl/output/com/systinet/demos/stock/StockQuoteService';
    s.methodName = 'getAvailableStocks';
    // set parameters (list of arguments; each one can be of type sh_SOAPParameter)
    s.setParameters(    );
    // try call
    try {
      s.asyncInvoke(runFinished);
      return false;
    }
    catch (ex) {
      error.where = 'during_asyncInvoke';
      error.detail = ex;
      return true;
    }
  }

  function runFinished(resp, call) {
    sh_printEndOfConnecting(node);
    if (resp == null) return;
    request = call;
    response = resp;
    if (resp.fault != null) {
      error.isError = true;
      error.where = 'SOAPFault';
      error.detail = resp.fault;
    } else {
      feed(resp, call);
    }
    if (error.isError) {
      sh_errorCase(error);
    }
  }

  function feed(resp, call) {
    try {
      var xslProc;
      // import "id" nodes to the "href" nodes
      if (sh_browser == 'IE') {
        xslProc = deHREF.createProcessor();
        xslProc.input = resp._XMLHttpRequest.responseXML;
        xslProc.transform();
      }
      // apply user stylesheet
      if (sh_browser == 'IE') {
        var input = __parseStringInDOMDocument(xslProc.output);
        var userXSLT = __readInXSLT(callXslt);
        var userXslProc = userXSLT.createProcessor();
        // transform output of XSLT-processing from string to XML (once Mozilla works this will change)
        userXslProc.input = input;
        sh_debugFnc(input, 'Response with resolved references');
        userXslProc.transform();
        var output = userXslProc.output;
      }
      node.innerHTML = output;
    }
    catch (ex) {
      error.isError = true;
      error.where = 'during_getting_answer';
      error.detail = ex;
    }
  }


}


function StockQuoteService_getQuote(id, callXslt, p0) {
  var node = __getNodeForId(id);
  sh_printStartOfConnecting(node);
  var error = {
    isError : false,
    where : '',
    detail : null
  }
  var request = null;
  var response = null;
  error.isError = call();
  if (error.isError) {
    sh_errorCase(error);
  }

  function call() {
    var s = new sh_SOAPCall();
    s.destinationURI = StockQuoteService_destinationURI;
    s.actionURI = '';
    s.targetObjectURI = 'http://idoox.com/wasp/tools/java2wsdl/output/com/systinet/demos/stock/StockQuoteService';
    s.methodName = 'getQuote';
    // set parameters (list of arguments; each one can be of type sh_SOAPParameter)
    s.setParameters(      new sh_SOAPParameter('p0', 'string', 'http://www.w3.org/2001/XMLSchema', 'primitive', p0)    );
    // try call
    try {
      s.asyncInvoke(runFinished);
      return false;
    }
    catch (ex) {
      error.where = 'during_asyncInvoke';
      error.detail = ex;
      return true;
    }
  }

  function runFinished(resp, call) {
    sh_printEndOfConnecting(node);
    if (resp == null) return;
    request = call;
    response = resp;
    if (resp.fault != null) {
      error.isError = true;
      error.where = 'SOAPFault';
      error.detail = resp.fault;
    } else {
      feed(resp, call);
    }
    if (error.isError) {
      sh_errorCase(error);
    }
  }

  function feed(resp, call) {
    try {
      var xslProc;
      // import "id" nodes to the "href" nodes
      if (sh_browser == 'IE') {
        xslProc = deHREF.createProcessor();
        xslProc.input = resp._XMLHttpRequest.responseXML;
        xslProc.transform();
      }
      // apply user stylesheet
      if (sh_browser == 'IE') {
        var input = __parseStringInDOMDocument(xslProc.output);
        var userXSLT = __readInXSLT(callXslt);
        var userXslProc = userXSLT.createProcessor();
        // transform output of XSLT-processing from string to XML (once Mozilla works this will change)
        userXslProc.input = input;
        sh_debugFnc(input, 'Response with resolved references');
        userXslProc.transform();
        var output = userXslProc.output;
      }
      node.innerHTML = output;
    }
    catch (ex) {
      error.isError = true;
      error.where = 'during_getting_answer';
      error.detail = ex;
    }
  }


}


