<xsl:stylesheet xmlns:xsl = "http://www.w3.org/1999/XSL/Transform" version = "1.0" xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon" > 

<xsl:output method="html"/>

<xsl:template match="/operation">
<form>
<fieldset>
  <legend><xsl:value-of select="title/text()"/></legend>
  <table border="0" cellspacing="0" cellpadding="1">
  <tr>
    <th valign="top" align="left" rowspan="2">Request: </th>
    <td align="left">
      <table border="0">
	<xsl:apply-templates select="param"/>
      </table>
    </td>
  </tr>
  <tr>
    <td>
      <xsl:apply-templates select="submit"/>
    </td>
  </tr>
  <tr valign="top" align="left">
    <th>Response: </th>
    <td>
      <div><xsl:attribute name="id"><xsl:value-of select="outputId/text()"/></xsl:attribute></div>
    </td>
  </tr>
  </table>
</fieldset>
</form>
</xsl:template>

<xsl:template match="param">
  <xsl:param name="insert"/>
  <tr>
    <td valign="top"><xsl:value-of select="label/text()"/></td>
    <td><xsl:copy-of select="input"/></td>
    <td><xsl:copy-of select="$insert"/></td>
  </tr>
</xsl:template>

<xsl:template match="param[struct]">
  <xsl:param name="insert" select="'XxX'"/>
  <tr>
    <xsl:if test="$insert='XxX'">
      <th valign="top"><xsl:value-of select="label/text()"/></th>
    </xsl:if>
    <td>
      <table border="1">
	<xsl:apply-templates select="struct/param">
	</xsl:apply-templates>
      </table>
    </td>
    <xsl:if test="not($insert='XxX')">
      <td><xsl:copy-of select="$insert"/></td>
    </xsl:if>
  </tr>
</xsl:template>

<xsl:template match="param[array]">
  <tr>
    <th valign="top"><xsl:value-of select="label/text()"/></th>
    <td>
      <div class="array" max="0">
	<xsl:attribute name="id">
	  <xsl:text>array_</xsl:text><xsl:value-of select="@id"/>
	</xsl:attribute>
	<div style="display: none;">
	  <xsl:attribute name="id">
	    <xsl:text>templ_</xsl:text><xsl:value-of select="@id"/>
	  </xsl:attribute>
	  <table border="1">
	    <xsl:apply-templates select="array/param">
	      <xsl:with-param name="insert">
		<input type="button" value="remove" onclick="var tmp=this.getAttribute('id'); remove(tmp.substring(tmp.indexOf('remov_')+6), 'placeTo');">
		  <xsl:attribute name="id">
		    <xsl:text>remov_</xsl:text><xsl:value-of select="@id"/>
		  </xsl:attribute>
		  <xsl:attribute name="onclick">
		    <xsl:text>var tmp=this.getAttribute('id'); __removeFromArray('templ_' + tmp.substring(tmp.indexOf('remov_')+6), 'placeto_</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>', 'templ_</xsl:text>
		    <xsl:value-of select="@id"/>
		    <xsl:text>');</xsl:text>
		  </xsl:attribute>		  
		</input>
	      </xsl:with-param>
	    </xsl:apply-templates>
	  </table>
	</div>
	<div>
	  <xsl:attribute name="id">
	    <xsl:text>placeto_</xsl:text><xsl:value-of select="@id"/>
	  </xsl:attribute>
	</div>
	<input type="button" value="add">
	  <xsl:attribute name="onclick">
	    <xsl:text>__addToArray('templ_</xsl:text><xsl:value-of select="@id"/><xsl:text>', 'placeto_</xsl:text>
	    <xsl:value-of select="@id"/><xsl:text>', 'templ_</xsl:text><xsl:value-of select="@id"/><xsl:text>');</xsl:text>
	  </xsl:attribute>
	</input>
      </div>
    </td>
  </tr>
</xsl:template>

<xsl:template match="submit">
  <xsl:copy-of select="node()"/>  
  <br/>
  <br/>
</xsl:template>


</xsl:stylesheet>