/*
 *  additional needed functions (IE only parts)
 */


/************************
 * path to global files *
 ************************/
if (!__pathToGlobals)
  var __pathToGlobals = 'global';

/**************************************************
 * path to stylesheet for included HTML-fragments *
 **************************************************/
if (!__pathToXSLTForHTMLFragments)
  var __pathToXSLTForHTMLFragments = 'global/FormatIncludeFragments.xsl';

/**************
 * debug mode *
 **************/
if (!__debug)
  var __debug = false;

/***************
 * get browser *
 ***************/
var __browser = null;
if (document.documentElement && document.documentElement.applyElement) {	// IE5
  __browser = 'IE';
} else if (document.implementation && document.implementation.createDocument) {	// Mozilla
  __browser = 'NN';
} else {
  alert("You're probably using browser this application was not developed for.")
}

/*********************************************************
 * function for creating DOMDocument from the source URL *
 *********************************************************/
function __readInDOMDocument(url) {
  try {
    if (__browser == 'IE') {
      var xmlDoc = new ActiveXObject('Msxml2.DOMDocument');
      xmlDoc.validateOnParse = false;
      xmlDoc.async = false;
      xmlDoc.load(url);
      return xmlDoc;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in loading DOMDocument:\n\n'+ex);
  }
}
function __parseStringInDOMDocument(str) {
  try {
    if (__browser == 'IE') {
      var xmlDoc = new ActiveXObject('Msxml2.DOMDocument');
      xmlDoc.validateOnParse = false;
      xmlDoc.async = false;
      xmlDoc.loadXML(str);
      return xmlDoc;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in loading DOMDocument:\n\n'+ex);
  }
}

/*********************************************************
 * function for including HTML-fragments inside the node *
 *********************************************************/
function __includeHTMLFragment(src, id) {
  try {
    var node = document.getElementById(id);
    var xmlDoc = __readInDOMDocument(src);
    if (__browser == 'IE') {
      var xslDoc = __readInXSLT(__pathToXSLTForHTMLFragments);
      var xslProc = xslDoc.createProcessor();
      xslProc.input = xmlDoc;
      xslProc.transform();
      node.innerHTML = xslProc.output;
      //node.innerHTML = xmlDoc.xml;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in retrieving node for include HTML-fragment into:\n\n'+ex);
  }
}

/***********************************************
 * function for creating XSLT-transform object *
 ***********************************************/
function __readInXSLT(xsltFile) {
  try {
    if (__browser == 'IE') {
      var xslt = new ActiveXObject("Msxml2.XSLTemplate");
      var xslDoc = new ActiveXObject("Msxml2.FreeThreadedDOMDocument");
      xslDoc.async = false;
      xslDoc.load(xsltFile);
      xslt.stylesheet = xslDoc;
    }
    return xslt;
  }
  catch (ex) {
    if (__debug) alert('Exception in loading XSLT file:\n\n'+ex);
  }
}

/***********************************
 * function for including JS-files *
 * (you must eval returned value)  *
 ***********************************/
function __readInJS(jsFile) {
  try {
    if (__browser == 'IE') {
      var textDoc = new ActiveXObject('Msxml2.XMLHTTP');
      textDoc.open('GET', jsFile, false);
      textDoc.send(null);
      return textDoc.responseText;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in loading JavaScript file:\n\n'+ex);
  }
}

/********************
 * DOM "extensions" *
 ********************/
// function for retrieving the first child element
function __getFirstChild(node) {
  try {
    var i = 0;
    while ((node.childNodes[i].nodeType != 1) && (i<node.childNodes.length))
      i++;
    if (node.childNodes[i].nodeType == 1) {
      return node.childNodes[i];
    } else {
      return null;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in __getFirstChild():\n\n'+ex);
    return null;
  }
}
// function for retrieving the first child element with specified name
function __getFirstChildWithName(node, name) {
  try {
    var i = 0;
    while ((node.childNodes[i].nodeName != name) && (i<node.childNodes.length))
      i++;
    if ( node.childNodes[i].nodeName == name ) {
      return node.childNodes[i];
    } else {
      return null;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in __getFirstChildWithName():\n\n'+ex);
    return null;
  }
}
// function for retrieving the first element with specified name and namespace 
function __getFirstElementWithNameNS(node, namespace, name) {
  try {
    if (__browser == 'IE') {	// no namespace method available
      var _all = node.getElementsByTagName('*');
      for (var i=0; i<_all.length; i++) {
        var el = _all[i];
        var el_index = el.nodeName.indexOf(':');
        if (el_index != -1) {
          var el_name = el.nodeName.substring(el_index + 1);
          if (el_name == name)
            return el;
        }
      }
      return null;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in __getFirstElementWithNameNS():\n\n'+ex);
    return null;
  }
}
// function for retrieving the node for the specified ID
function __getNodeForId(id) {
  try {
    var node = document.getElementById(id);
    return node;
  }
  catch (ex) {
    if (__debug) alert('Exception in retrieving node for id: '+ex);
    return null;
  }
}

/**************************************************************
 * function for getting the value of various HTML form inputs *
 **************************************************************/
function __getHTMLInput(id) {
  var node = __getNodeForId(id);
  try {
    var nodeName = node.nodeName;
    switch (nodeName) {
      case 'input':
      case 'INPUT':
        //var subType = node.getAttribute('type');
        return node.value;
        break;
      case 'textarea':
      case 'TEXTAREA':
        return node.value;
        break;
      case 'select':
      case 'SELECT':
        return node.getElementsByTagName('option')[node.selectedIndex].value;
        break;
    }
  }
  catch (ex) {
    if (__debug) alert('Exception in getting the value of HTML form input ' + id + ': '+ex);
    return null;
  }
}


function __clearResponse(id) {
  var node = __getNodeForId(id);
  node.innerHTML = "";
}





/***********************************************************************
 * functions for adding/removing array members and for accessing them. *
 ***********************************************************************/


function __addToArray(id, where, prefix) {
  var nodeForPlaceTo = document.getElementById(where);
  //
  var nodeToClone = document.getElementById(id);
  var parentNodeOfCloning = nodeToClone.parentNode;
  //
  var max = parseInt(parentNodeOfCloning.getAttribute('max'));
  max++;
  parentNodeOfCloning.setAttribute('max', max);
  //
  var tmpNode = nodeToClone.cloneNode(true);
  tmpNode.style.display = 'block';
  __setArrayIndex(tmpNode, max, prefix.length);
  nodeForPlaceTo.appendChild(tmpNode);
}

function __removeFromArray(id, from, prefix) {
  var nodeForPlaceTo = document.getElementById(from);
  //
  var nodeToRemove = document.getElementById(id);

  if (nodeForPlaceTo == null) alert("Internal error: nodeFromRemove " + from + " not found");
  if (nodeToRemove   == null) alert("Internal error: nodeToRemove " + id + " not found");

  var mainParent = __getMainParent(nodeToRemove);
  nodeForPlaceTo.removeChild(nodeToRemove);
  var max = parseInt(mainParent.getAttribute('max'));
  max--;
  mainParent.setAttribute('max', max);
  var tmpNodeList = nodeForPlaceTo.childNodes;
  for (var i=0; i<tmpNodeList.length; i++)
    __setArrayIndex(tmpNodeList[i], i+1, prefix.length);
}

function __getMainParent(node) {
  var parent = node.parentNode;
  while ((parent.getAttribute('max') == '') || (parent.getAttribute('max') == null))
    parent = parent.parentNode;
  return parent;
}

function __setArrayIndex(currentElement, arrayIndex, prefixLength) {
  var id = currentElement.getAttribute("id");
  if ((id != '') && (id != null)) {
      //    alert("setting array index for " + currentElement.getAttribute("id") + ", prefix " + prefixLength);
    var lio = id.indexOf('-');
    var start, end;
    if (lio < 0) {
        lio   = prefixLength;

        start = id.substring(0, lio);
        end   = id.substring(lio);
    } else {
        start = id.substring(0, lio);
        end   = id.substring(id.indexOf('-', lio+1)+1);
    }

    //    alert("start " + start + ", end, " + end);

    id = start + "-" + arrayIndex + "-" + end;
    //    alert("setting " + id);
    currentElement.setAttribute("id", id);
  }
  var currentNode = currentElement.firstChild;
  while (currentNode != null) {
   	if (currentNode.nodeType == 1) {
      __setArrayIndex(currentNode, arrayIndex, prefixLength);
    }
    currentNode = currentNode.nextSibling;
  }
}

function __getMax(id) {
  var maxNode = document.getElementById(id);
  return maxNode.getAttribute('max');
}

function __openWebServicePage(page,serviceurl) {
    var w = window.open(page, ''); 
    function openhh() {
        if ( w.document.getElementById('serviceURI') == undefined ||
             w.document.getElementById('serviceURI') == null) {
            w.setTimeout(openhh, 100);            
        } else {
            w.document.getElementById('serviceURI').value=serviceurl;
        }
    }
    w.setTimeout(openhh, 100);
}